/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.block;

import agency.highlysuspect.incorporeal.IncBlockEntityTypes;
import agency.highlysuspect.incorporeal.block.entity.CorporeaPylonBlockEntity;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BlockMod;

public class CorporeaPylonBlock
extends BlockMod
implements EntityBlock {
    public static final EnumProperty<Which> WHICH = EnumProperty.m_61587_((String)"which", Which.class);
    private static final VoxelShape TOP_SHAPE = CorporeaPylonBlock.makeTopShape();
    private static final VoxelShape MIDDLE_SHAPE = CorporeaPylonBlock.makeMiddleShape();
    private static final VoxelShape BOTTOM_SHAPE = CorporeaPylonBlock.makeBottomShape();

    public CorporeaPylonBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(WHICH, (Comparable)((Object)Which.BOTTOM)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{WHICH}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Which)((Object)state.m_61143_(WHICH))) {
            default -> throw new IncompatibleClassChangeError();
            case Which.TOP -> TOP_SHAPE;
            case Which.MIDDLE -> MIDDLE_SHAPE;
            case Which.BOTTOM -> BOTTOM_SHAPE;
        };
    }

    @Nullable
    protected BlockState expectedNeighbor(BlockState self, Direction dir) {
        if (dir == Direction.UP) {
            return switch ((Which)((Object)self.m_61143_(WHICH))) {
                default -> throw new IncompatibleClassChangeError();
                case Which.TOP -> null;
                case Which.MIDDLE -> (BlockState)self.m_61124_(WHICH, (Comparable)((Object)Which.TOP));
                case Which.BOTTOM -> (BlockState)self.m_61124_(WHICH, (Comparable)((Object)Which.MIDDLE));
            };
        }
        if (dir == Direction.DOWN) {
            return switch ((Which)((Object)self.m_61143_(WHICH))) {
                default -> throw new IncompatibleClassChangeError();
                case Which.TOP -> (BlockState)self.m_61124_(WHICH, (Comparable)((Object)Which.MIDDLE));
                case Which.MIDDLE -> (BlockState)self.m_61124_(WHICH, (Comparable)((Object)Which.BOTTOM));
                case Which.BOTTOM -> null;
            };
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction fromDir, BlockState fromState, LevelAccessor level, BlockPos pos, BlockPos fromPos) {
        @Nullable BlockState expectedNeighbor = this.expectedNeighbor(state, fromDir);
        if (expectedNeighbor == null) {
            return state;
        }
        if (!Objects.equals(fromState, expectedNeighbor)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean moved) {
        super.m_6861_(state, level, pos, fromBlock, fromPos, moved);
        if (level.m_183326_().m_183582_(pos, (Object)state.m_60734_())) {
            level.m_186460_(pos, state.m_60734_(), 1);
        }
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        for (Direction dir : List.of(Direction.UP, Direction.DOWN)) {
            BlockState found;
            BlockState expected = this.expectedNeighbor(state, dir);
            if (expected == null || Objects.equals(expected, found = level.m_8055_(pos.m_142300_(dir)))) continue;
            level.m_7471_(pos, false);
            return;
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        if (pos.m_6630_(2).m_123342_() > level.m_151558_()) {
            return null;
        }
        if (!level.m_8055_(pos.m_6630_(1)).m_60629_(ctx)) {
            return null;
        }
        if (!level.m_8055_(pos.m_6630_(2)).m_60629_(ctx)) {
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_(WHICH, (Comparable)((Object)Which.BOTTOM));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.m_46597_(pos.m_6630_(1), (BlockState)state.m_61124_(WHICH, (Comparable)((Object)Which.MIDDLE)));
        level.m_46597_(pos.m_6630_(2), (BlockState)state.m_61124_(WHICH, (Comparable)((Object)Which.TOP)));
    }

    public PushReaction m_5537_(BlockState $$0) {
        return PushReaction.DESTROY;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(WHICH) == Which.BOTTOM) {
            return IncBlockEntityTypes.CORPOREA_PYLON.m_155264_(pos, state);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (state.m_61143_(WHICH) == Which.BOTTOM) {
            return CorporeaPylonBlock.createTickerHelper(type, IncBlockEntityTypes.CORPOREA_PYLON, CorporeaPylonBlockEntity::tick);
        }
        return null;
    }

    private static VoxelShape makeTopShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.5625, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.75, (double)0.25, (double)0.75, (double)1.0625, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.625, (double)0.625, (double)0.75, (double)0.9375, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.75, (double)0.625, (double)0.375, (double)1.0625, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.625, (double)0.25, (double)0.375, (double)0.9375, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        return shape.m_83296_();
    }

    private static VoxelShape makeMiddleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.375, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.625, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape.m_83296_();
    }

    private static VoxelShape makeBottomShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5, (double)0.75, (double)0.25, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.5, (double)0.75, (double)0.875, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5, (double)0.125, (double)0.25, (double)1.0, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.5, (double)0.125, (double)0.875, (double)1.0, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.5, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape.m_83296_();
    }

    public static enum Which implements StringRepresentable
    {
        TOP,
        MIDDLE,
        BOTTOM;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

