/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.block;

import agency.highlysuspect.incorporeal.computer.types.DataTypes;
import agency.highlysuspect.incorporeal.computer.types.Datum;
import agency.highlysuspect.incorporeal.corporea.SolidifiedRequest;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class CorporeaSolidifierBlock
extends Block {
    public CorporeaSolidifierBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public void receiveRequest(Level level, BlockPos pos, SolidifiedRequest request) {
        this.receiveDatum(level, pos, DataTypes.SOLIDIFIED_REQUEST.datumOf(request));
    }

    public void receiveDatum(Level level, BlockPos pos, Datum<?> datum) {
        if (level == null || level.m_5776_()) {
            return;
        }
        ItemStack ticket = datum.produceTicket();
        BlockPos invPos = this.getInvPos(level, pos);
        if (invPos != null && IXplatAbstractions.INSTANCE.insertToInventory(level, invPos, Direction.UP, ticket, true).m_41619_()) {
            InventoryHelper.checkEmpty((ItemStack)IXplatAbstractions.INSTANCE.insertToInventory(level, invPos, Direction.UP, ticket, false));
        } else {
            ItemEntity item = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.25, (double)pos.m_123343_() + 0.5, ticket);
            level.m_7967_((Entity)item);
        }
    }

    @Nullable
    private BlockPos getInvPos(Level level, BlockPos worldPosition) {
        BlockPos downOne = worldPosition.m_7495_();
        if (IXplatAbstractions.INSTANCE.hasInventory(level, downOne, Direction.UP)) {
            return downOne;
        }
        BlockPos downTwo = worldPosition.m_6625_(2);
        if (IXplatAbstractions.INSTANCE.hasInventory(level, downTwo, Direction.UP)) {
            return downTwo;
        }
        return null;
    }
}

