/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.block;

import agency.highlysuspect.incorporeal.block.CrappyDiodeBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public class CrappyComparatorBlock
extends CrappyDiodeBlock {
    public static final BooleanProperty SENSITIVE = BooleanProperty.m_61465_((String)"sensitive");

    public CrappyComparatorBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SENSITIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> $$0) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)$$0.m_61104_(new Property[]{SENSITIVE}));
    }

    protected int m_5968_(BlockGetter level, BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)f_52496_) != false ? 15 : 0;
    }

    private boolean calculateOutput(Level level, BlockPos pos, BlockState state) {
        int back = this.m_7312_(level, pos, state);
        if (back == 0) {
            return false;
        }
        int side = this.m_52547_((LevelReader)level, pos, state);
        if (side > back) {
            return false;
        }
        int difference = back - side;
        if (((Boolean)state.m_61143_((Property)SENSITIVE)).booleanValue()) {
            return difference != 0;
        }
        return difference == 15;
    }

    protected int m_7312_(Level level, BlockPos blockPos, BlockState blockState) {
        int i = super.m_7312_(level, blockPos, blockState);
        Direction direction = (Direction)blockState.m_61143_((Property)f_54117_);
        BlockPos blockPos2 = blockPos.m_142300_(direction);
        BlockState blockState2 = level.m_8055_(blockPos2);
        if (blockState2.m_60807_()) {
            i = blockState2.m_60674_(level, blockPos2);
        } else if (i < 15 && blockState2.m_60796_((BlockGetter)level, blockPos2)) {
            blockPos2 = blockPos2.m_142300_(direction);
            blockState2 = level.m_8055_(blockPos2);
            ItemFrame itemFrame = this.getItemFrame(level, direction, blockPos2);
            int j = Math.max(itemFrame == null ? Integer.MIN_VALUE : itemFrame.m_31824_(), blockState2.m_60807_() ? blockState2.m_60674_(level, blockPos2) : Integer.MIN_VALUE);
            if (j != Integer.MIN_VALUE) {
                i = j;
            }
        }
        return i;
    }

    @Nullable
    private ItemFrame getItemFrame(Level level, Direction direction, BlockPos blockPos) {
        List list = level.m_6443_(ItemFrame.class, new AABB((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (double)(blockPos.m_123341_() + 1), (double)(blockPos.m_123342_() + 1), (double)(blockPos.m_123343_() + 1)), itemFrame -> itemFrame != null && itemFrame.m_6350_() == direction);
        return list.size() == 1 ? (ItemFrame)list.get(0) : null;
    }

    protected int m_52547_(LevelReader level, BlockPos pos, BlockState state) {
        Direction $$3 = (Direction)state.m_61143_((Property)f_54117_);
        Direction $$4 = $$3.m_122427_();
        Direction $$5 = $$3.m_122428_();
        return Math.max(this.m_52551_(level, pos.m_142300_($$4), $$4), this.m_52551_(level, pos.m_142300_($$5), $$5));
    }

    protected int m_52551_(LevelReader level, BlockPos pos, Direction direction) {
        BlockState $$3 = level.m_8055_(pos);
        if (this.m_6137_($$3)) {
            if ($$3.m_60713_(Blocks.f_50330_)) {
                return 15;
            }
            return $$3.m_60713_(Blocks.f_50088_) ? ((Integer)$$3.m_61143_((Property)RedStoneWireBlock.f_55500_)).intValue() : level.m_46852_(pos, direction);
        }
        return 0;
    }

    public boolean m_7899_(BlockState $$0) {
        return true;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!player.m_150110_().f_35938_) {
            return InteractionResult.PASS;
        }
        float f = (Boolean)(blockState = (BlockState)blockState.m_61122_((Property)SENSITIVE)).m_61143_((Property)SENSITIVE) != false ? 0.55f : 0.5f;
        level.m_5594_(player, blockPos, SoundEvents.f_11762_, SoundSource.BLOCKS, 0.3f, f);
        level.m_7731_(blockPos, blockState, 2);
        this.refreshOutputState(level, blockPos, blockState);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected void m_7321_(Level level, BlockPos blockPos, BlockState blockState) {
        boolean j;
        boolean i;
        if (!level.m_183326_().m_183588_(blockPos, (Object)this) && (i = this.calculateOutput(level, blockPos, blockState)) != (j = ((Boolean)blockState.m_61143_((Property)f_52496_)).booleanValue())) {
            TickPriority tickPriority = this.m_52573_((BlockGetter)level, blockPos, blockState) ? TickPriority.HIGH : TickPriority.NORMAL;
            level.m_186464_(blockPos, (Block)this, this.m_6112_(blockState), tickPriority);
        }
    }

    private void refreshOutputState(Level level, BlockPos pos, BlockState state) {
        boolean isPowered;
        boolean shouldPower = this.calculateOutput(level, pos, state);
        if (shouldPower != (isPowered = ((Boolean)state.m_61143_((Property)f_52496_)).booleanValue())) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52496_, (Comparable)Boolean.valueOf(shouldPower)), 2);
            this.m_52580_(level, pos, state);
        }
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        this.refreshOutputState((Level)level, pos, state);
    }

    public boolean getWeakChanges(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        if (pos.m_123342_() == neighbor.m_123342_() && world instanceof Level && !((Level)world).m_5776_()) {
            state.m_60690_((Level)world, pos, world.m_8055_(neighbor).m_60734_(), neighbor, false);
        }
    }
}

