/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.block;

import agency.highlysuspect.incorporeal.Inc;
import agency.highlysuspect.incorporeal.corporea.FrameReader;
import agency.highlysuspect.incorporeal.mixin.ItemFrameAccessor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.mixin.AccessorItemEntity;

public class FrameTinkererBlock
extends BlockModWaterloggable {
    private static final double HEIGHT = 0.1875;
    private static final VoxelShape BOX = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.1875, (double)1.0);

    public FrameTinkererBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState $$0, BlockGetter $$1, BlockPos $$2, CollisionContext $$3) {
        return BOX;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{BlockStateProperties.f_61448_}));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        if (!held.m_41619_()) {
            if (!level.m_5776_()) {
                ItemStack deposit;
                if (player.m_7500_()) {
                    deposit = held.m_41777_();
                    deposit.m_41764_(1);
                } else {
                    deposit = held.m_41620_(1);
                }
                FrameTinkererBlock.spawnStack(level, pos, deposit);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean moving) {
        boolean isPowered;
        boolean shouldPower = level.m_46753_(pos);
        if (shouldPower != (isPowered = ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue())) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(shouldPower)));
            if (!level.m_5776_() && shouldPower) {
                List<ItemFrame> frameChoices;
                List itemChoices = level.m_6443_(ItemEntity.class, new AABB(pos), ent -> ent.m_6084_() && !ent.m_32055_().m_41619_() && ent.m_32055_().m_41613_() == 1);
                boolean allowEmpty = !itemChoices.isEmpty();
                List<ItemFrame> list = frameChoices = allowEmpty ? FrameReader.near(level, pos) : FrameReader.nonEmptyNear(level, pos);
                if (frameChoices.isEmpty()) {
                    return;
                }
                ItemFrame frame = Inc.choose(frameChoices, level.m_5822_());
                if (itemChoices.isEmpty()) {
                    FrameTinkererBlock.switchWithNothing(level, pos, frame);
                } else {
                    ItemEntity item = (ItemEntity)Inc.choose(itemChoices, level.m_5822_());
                    FrameTinkererBlock.switchWithEntity(level, pos, frame, item);
                }
            }
        }
    }

    private static ItemStack removeStackFromFrame(ItemFrame frame) {
        ((ItemFrameAccessor)frame).inc$removeFramedMap(frame.m_31822_());
        ItemStack frameItem = frame.m_31822_().m_41777_();
        frame.m_31805_(ItemStack.f_41583_);
        return frameItem;
    }

    private static void switchWithNothing(Level level, BlockPos pos, ItemFrame frame) {
        ItemStack frameItem = FrameTinkererBlock.removeStackFromFrame(frame);
        frame.m_5496_(frame.m_142544_(), 1.0f, 1.0f);
        FrameTinkererBlock.spawnStack(level, pos, frameItem);
    }

    private static void switchWithEntity(Level level, BlockPos pos, ItemFrame frame, ItemEntity switchWith) {
        ItemStack formerlyInFrame = FrameTinkererBlock.removeStackFromFrame(frame);
        frame.m_31805_(switchWith.m_32055_());
        switchWith.m_32045_(formerlyInFrame);
        switchWith.m_32010_(30);
        ((AccessorItemEntity)switchWith).setAge(0);
    }

    private static void spawnStack(Level level, BlockPos pos, ItemStack stack) {
        FrameTinkererBlock.spawnStack(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1875, (double)pos.m_123343_() + 0.5, stack);
    }

    private static void spawnStack(Level level, double x, double y, double z, ItemStack stack) {
        ItemEntity ent = new ItemEntity(level, x, y, z, stack, 0.0, 0.0, 0.0);
        ent.m_32010_(30);
        level.m_7967_((Entity)ent);
    }
}

