/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.block.entity;

import agency.highlysuspect.incorporeal.platform.IncXplat;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.block.tile.TileMod;

public abstract class AbstractSoulCoreBlockEntity
extends TileMod
implements IManaReceiver {
    public static final DamageSource SOUL = IncXplat.INSTANCE.createDamageSource("incorporeal.soul").m_19389_();
    protected GameProfile ownerProfile;
    protected int mana;
    protected int signal;

    public AbstractSoulCoreBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected abstract int getMaxMana();

    protected abstract void tick();

    protected abstract int computeSignal();

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractSoulCoreBlockEntity self) {
        self.tick();
        int newSignal = self.computeSignal();
        if (self.signal != newSignal) {
            self.signal = newSignal;
            self.m_6596_();
        }
        if (self.mana <= 0 && self.hasOwnerProfile()) {
            self.onExpire();
        }
    }

    public boolean hasOwnerProfile() {
        return this.ownerProfile != null;
    }

    public GameProfile getOwnerProfile() {
        return this.ownerProfile;
    }

    public void setOwnerProfile(GameProfile ownerProfile) {
        this.ownerProfile = ownerProfile;
        this.m_6596_();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
    }

    public Optional<ServerPlayer> findPlayer() {
        if (this.f_58857_ == null || !this.hasOwnerProfile()) {
            return Optional.empty();
        }
        if (this.f_58857_.m_5776_()) {
            throw new IllegalStateException("findPlayer on client level");
        }
        MinecraftServer server = this.f_58857_.m_142572_();
        assert (server != null);
        ServerPlayer player = server.m_6846_().m_11259_(this.ownerProfile.getId());
        if (player == null || player.f_19853_ != this.f_58857_) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public Optional<Player> findPlayerClientSafeLol() {
        if (this.f_58857_ == null || !this.hasOwnerProfile()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.f_58857_.m_46003_(this.ownerProfile.getId()));
    }

    public InteractionResult activate(Player player, InteractionHand hand) {
        assert (this.f_58857_ != null);
        if (!player.m_36316_().equals((Object)this.ownerProfile)) {
            this.setOwnerProfile(player.m_36316_());
            if (!this.f_58857_.m_5776_()) {
                player.m_6469_(SOUL, 5.0f);
                this.receiveInitialMana();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void receiveInitialMana() {
        int n = this.getMaxMana() / 2;
        if (this.mana < n) {
            this.mana = n;
        }
        this.m_6596_();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
    }

    public void drainMana(int howMuch) {
        if (howMuch < 0) {
            howMuch = 0;
        }
        this.mana -= howMuch;
        if (this.mana < 0) {
            this.mana = 0;
        }
        this.m_6596_();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
    }

    public void onExpire() {
        this.findPlayerClientSafeLol().ifPresent(p -> p.m_6469_(SOUL, 5.0f));
        this.setOwnerProfile(null);
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11913_, SoundSource.BLOCKS, 0.5f, 1.2f);
        }
    }

    public int getSignal() {
        return this.signal;
    }

    public boolean isFull() {
        return this.mana >= this.getMaxMana();
    }

    public void receiveMana(int moreMana) {
        this.mana = Math.min(this.mana + moreMana, this.getMaxMana() * 2);
        this.m_6596_();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
    }

    public boolean canReceiveManaFromBursts() {
        return true;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        if (this.ownerProfile != null) {
            tag.m_128365_("OwnerProfile", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.ownerProfile));
        }
        tag.m_128405_("Mana", this.mana);
        tag.m_128405_("Signal", this.signal);
    }

    public void readPacketNBT(CompoundTag cmp) {
        super.readPacketNBT(cmp);
        this.ownerProfile = cmp.m_128441_("OwnerProfile") ? NbtUtils.m_129228_((CompoundTag)cmp.m_128469_("OwnerProfile")) : null;
        this.mana = cmp.m_128451_("Mana");
        this.signal = cmp.m_128451_("Signal");
    }

    public Level getManaReceiverLevel() {
        return this.f_58857_;
    }

    public BlockPos getManaReceiverPos() {
        return this.f_58858_;
    }

    public static class WandHud
    implements IWandHUD {
        private final AbstractSoulCoreBlockEntity tile;

        public WandHud(AbstractSoulCoreBlockEntity tile) {
            this.tile = tile;
        }

        public void renderHUD(PoseStack ms, Minecraft mc) {
            String name = new ItemStack((ItemLike)this.tile.m_58900_().m_60734_()).m_41786_().getString();
            BotaniaAPIClient.instance().drawSimpleManaHUD(ms, 0xEE4444, this.tile.mana, this.tile.getMaxMana(), name);
        }
    }
}

