/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.block.entity;

import agency.highlysuspect.incorporeal.IncBlockEntityTypes;
import agency.highlysuspect.incorporeal.block.entity.DataStorageBlockEntity;
import agency.highlysuspect.incorporeal.block.entity.Multibindable;
import agency.highlysuspect.incorporeal.computer.DataRayClipContext;
import agency.highlysuspect.incorporeal.computer.capabilities.DatumAcceptor;
import agency.highlysuspect.incorporeal.computer.types.DataReducers;
import agency.highlysuspect.incorporeal.computer.types.Datum;
import agency.highlysuspect.incorporeal.net.DataFunnelEffect;
import agency.highlysuspect.incorporeal.net.IncNetwork;
import agency.highlysuspect.incorporeal.util.MoreNbtHelpers;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DataFunnelBlockEntity
extends DataStorageBlockEntity
implements Multibindable {
    private Set<BlockPos> bindTargets = new HashSet<BlockPos>();

    public DataFunnelBlockEntity(BlockPos pos, BlockState state) {
        super(IncBlockEntityTypes.DATA_FUNNEL, pos, state);
    }

    @Override
    public Set<BlockPos> getBindings() {
        return this.bindTargets;
    }

    @Override
    public int getBindRange() {
        return 12;
    }

    public void doIt() {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return;
        }
        ServerLevel slevel = (ServerLevel)this.f_58857_;
        ArrayList leftoverData = new ArrayList(this.bindTargets.size());
        DataFunnelEffect effect = new DataFunnelEffect();
        for (BlockPos bindingPos : this.bindTargets) {
            DataRayClipContext clip = DataRayClipContext.performClip(slevel, bindingPos, this.f_58858_);
            for (DataRayClipContext.Pairing pairing : clip.pairings) {
                DataRayClipContext.ProviderEntry providerEntry = pairing.provider();
                Vec3 sparkleStart = providerEntry.pos();
                Datum<?> datum = providerEntry.provider().readDatum();
                for (DataRayClipContext.LensEntry lensEntry : providerEntry.lenses()) {
                    effect.addLine(sparkleStart, lensEntry.pos(), datum.color());
                    sparkleStart = lensEntry.pos();
                    datum = lensEntry.lens().filter(datum);
                }
                DataRayClipContext.AcceptorEntry acceptorEntry = pairing.acceptor();
                effect.addLine(sparkleStart, acceptorEntry.pos(), datum.color());
                DatumAcceptor acceptor = acceptorEntry.acceptor();
                if (acceptor == this && !datum.isEmpty()) {
                    leftoverData.add(datum);
                    continue;
                }
                acceptor.acceptDatum(datum);
            }
        }
        this.acceptDatum(DataReducers.reduce(leftoverData));
        if (!effect.isEmpty()) {
            IncNetwork.sendToAllWatching(effect, slevel, this.f_58858_);
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        super.writePacketNBT(cmp);
        cmp.m_128365_("Binds", (Tag)MoreNbtHelpers.writeBlockPosSet(this.bindTargets));
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        super.readPacketNBT(cmp);
        this.bindTargets = MoreNbtHelpers.readBlockPosSet(cmp.m_128437_("Binds", 10));
    }
}

