/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.block.entity;

import agency.highlysuspect.incorporeal.IncBlockEntityTypes;
import agency.highlysuspect.incorporeal.computer.capabilities.DatumAcceptor;
import agency.highlysuspect.incorporeal.computer.capabilities.DatumProvider;
import agency.highlysuspect.incorporeal.computer.types.Datum;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.TileMod;

public class DataStorageBlockEntity
extends TileMod
implements DatumAcceptor,
DatumProvider {
    protected Datum<?> datum = Datum.EMPTY;
    protected int signal = 0;

    public DataStorageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static DataStorageBlockEntity makePointedDatastoneTbh(BlockPos pos, BlockState state) {
        return new DataStorageBlockEntity(IncBlockEntityTypes.POINTED_DATASTONE, pos, state);
    }

    @Override
    public void acceptDatum(@NotNull Datum<?> datum) {
        boolean changed = !this.datum.equals(datum);
        this.datum = datum;
        this.signal = datum.signal();
        if (changed) {
            this.m_6596_();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        }
    }

    @Override
    @NotNull
    public Datum<?> readDatum(boolean doIt) {
        return this.datum;
    }

    public int signal() {
        return this.signal;
    }

    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128365_("Datum", (Tag)this.datum.save());
    }

    public void readPacketNBT(CompoundTag cmp) {
        this.datum = Datum.load(cmp.m_128469_("Datum"));
        this.signal = this.datum.signal();
    }
}

