/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.block.entity;

import agency.highlysuspect.incorporeal.IncBlockEntityTypes;
import agency.highlysuspect.incorporeal.block.entity.AbstractSoulCoreBlockEntity;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaNodeDetector;
import vazkii.botania.api.corporea.ICorporeaRequest;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.impl.corporea.AbstractCorporeaNode;

public class EnderSoulCoreBlockEntity
extends AbstractSoulCoreBlockEntity {
    @Nullable
    private PlayerEnderChestContainer enderChest = null;

    public EnderSoulCoreBlockEntity(BlockPos pos, BlockState state) {
        super(IncBlockEntityTypes.ENDER_SOUL_CORE, pos, state);
    }

    @Override
    protected int getMaxMana() {
        return 5000;
    }

    @Override
    protected void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.enderChest = this.findPlayer().map(Player::m_36327_).orElse(null);
    }

    @Override
    public int computeSignal() {
        if (this.enderChest == null) {
            return 0;
        }
        return AbstractContainerMenu.m_38938_((Container)this.enderChest);
    }

    public void trackItemMovement(int itemCount) {
        this.drainMana(5 * itemCount);
    }

    @Nullable
    public PlayerEnderChestContainer getEnderChest() {
        return this.enderChest;
    }

    public static class NodeDetector
    implements ICorporeaNodeDetector {
        @Nullable
        public ICorporeaNode getNode(Level world, ICorporeaSpark spark) {
            EnderSoulCoreBlockEntity be = (EnderSoulCoreBlockEntity)IncBlockEntityTypes.ENDER_SOUL_CORE.m_58949_((BlockGetter)world, spark.getAttachPos());
            if (be == null) {
                return null;
            }
            return new Node(be, world, spark.getAttachPos(), spark);
        }

        public static class Node
        extends AbstractCorporeaNode {
            private final EnderSoulCoreBlockEntity be;

            public Node(EnderSoulCoreBlockEntity be, Level world, BlockPos pos, ICorporeaSpark spark) {
                super(world, pos, spark);
                this.be = be;
            }

            public List<ItemStack> countItems(ICorporeaRequest request) {
                PlayerEnderChestContainer container = this.be.getEnderChest();
                if (container == null) {
                    return Collections.emptyList();
                }
                return this.iterateOverSlots((Container)container, request, false);
            }

            public List<ItemStack> extractItems(ICorporeaRequest request) {
                PlayerEnderChestContainer container = this.be.getEnderChest();
                if (container == null) {
                    return Collections.emptyList();
                }
                List<ItemStack> extracted = this.iterateOverSlots((Container)container, request, true);
                for (ItemStack stack : extracted) {
                    this.be.trackItemMovement(stack.m_41613_());
                }
                return extracted;
            }

            protected List<ItemStack> iterateOverSlots(Container inv, ICorporeaRequest request, boolean doit) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = inv.m_6643_() - 1; i >= 0; --i) {
                    ItemStack copy;
                    ItemStack stackAt = inv.m_8020_(i);
                    if (!request.getMatcher().test(stackAt)) continue;
                    request.trackFound(stackAt.m_41613_());
                    int rem = Math.min(stackAt.m_41613_(), request.getStillNeeded() == -1 ? stackAt.m_41613_() : request.getStillNeeded());
                    if (rem <= 0) continue;
                    request.trackSatisfied(rem);
                    if (doit) {
                        copy = stackAt.m_41777_();
                        copy.m_41764_(rem);
                        if (this.getSpark().isCreative()) {
                            builder.add((Object)copy);
                        } else {
                            builder.addAll((Iterable)Node.breakDownBigStack((ItemStack)inv.m_7407_(i, rem)));
                        }
                        this.getSpark().onItemExtracted(copy);
                        request.trackExtracted(rem);
                        continue;
                    }
                    copy = stackAt.m_41777_();
                    copy.m_41764_(rem);
                    builder.add((Object)copy);
                }
                return builder.build();
            }
        }
    }
}

