/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.block.entity;

import agency.highlysuspect.incorporeal.IncBlockEntityTypes;
import agency.highlysuspect.incorporeal.net.FunnyEffect;
import agency.highlysuspect.incorporeal.util.Bigfunny;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;

public class FunnyBlockEntity
extends TileEntityFunctionalFlower {
    private final int range;
    private final int ticksBetweenNotes;
    private final int pitchShift;
    private final double sparkleHeight;
    private final int NOTE_MANA_COST = 10;
    private int clock = -1;

    public FunnyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int range, int ticksBetweenNotes, int pitchShift, double sparkleHeight) {
        super(type, pos, state);
        this.range = range;
        this.ticksBetweenNotes = ticksBetweenNotes;
        this.pitchShift = pitchShift;
        this.sparkleHeight = sparkleHeight;
    }

    public static FunnyBlockEntity big(BlockPos pos, BlockState state) {
        return new FunnyBlockEntity(IncBlockEntityTypes.FUNNY_BIG, pos, state, 4, 4, 0, 0.75);
    }

    public static FunnyBlockEntity small(BlockPos pos, BlockState state) {
        return new FunnyBlockEntity(IncBlockEntityTypes.FUNNY_SMALL, pos, state, 2, 3, 7, 0.6);
    }

    public void tickFlower() {
        Level level;
        int tick;
        super.tickFlower();
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_5776_()) {
            return;
        }
        BlockPos pos = this.getEffectivePos();
        if (this.redstoneSignal == 15) {
            if (this.clock != -1) {
                this.m_6596_();
            }
            this.clock = -1;
            return;
        }
        if (this.redstoneSignal > 0 || this.getMana() < 10) {
            return;
        }
        ++this.clock;
        this.m_6596_();
        int ticksBetween = this.ticksBetweenNotes / (this.overgrowth || this.overgrowthBoost ? 2 : 1);
        if (ticksBetween == 0) {
            ticksBetween = 1;
        }
        if ((tick = this.clock) < 0 || tick % ticksBetween != 0) {
            return;
        }
        EnumMap<NoteBlockInstrument, BlockPos> insts = this.findInsts(pos);
        FunnyEffect effect = new FunnyEffect(pos, this.sparkleHeight);
        boolean dirtyMana = false;
        dirtyMana |= this.doIt(tick /= ticksBetween, effect, insts, NoteBlockInstrument.FLUTE);
        dirtyMana |= this.doIt(tick, effect, insts, NoteBlockInstrument.SNARE);
        dirtyMana |= this.doIt(tick, effect, insts, NoteBlockInstrument.BASEDRUM);
        if (dirtyMana |= this.doIt(tick, effect, insts, NoteBlockInstrument.BASS)) {
            this.sync();
        }
        if (!effect.isEmpty() && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            effect.sendToAllWatching(slevel, pos);
        }
    }

    private EnumMap<NoteBlockInstrument, BlockPos> findInsts(BlockPos pos) {
        EnumMap<NoteBlockInstrument, BlockPos> result = new EnumMap<NoteBlockInstrument, BlockPos>(NoteBlockInstrument.class);
        assert (this.f_58857_ != null);
        for (BlockPos bp : BlockPos.m_121940_((BlockPos)pos.m_142082_(-this.range, 0, -this.range), (BlockPos)pos.m_142082_(this.range, 1, this.range))) {
            BlockState state = this.f_58857_.m_8055_(bp);
            if (!state.m_61138_((Property)BlockStateProperties.f_61395_)) continue;
            result.put((NoteBlockInstrument)state.m_61143_((Property)BlockStateProperties.f_61395_), bp.m_7949_());
        }
        return result;
    }

    private boolean doIt(int tick, FunnyEffect sparkleData, Map<NoteBlockInstrument, BlockPos> insts, NoteBlockInstrument inst) {
        assert (this.f_58857_ != null);
        if (this.getMana() < 10) {
            return false;
        }
        BlockPos noteblockPos = insts.get(inst);
        if (noteblockPos == null) {
            return false;
        }
        byte[] notes = Bigfunny.notesForTick(tick, inst);
        if (notes == null) {
            return false;
        }
        sparkleData.addLineTo(noteblockPos, notes);
        for (byte note : notes) {
            if (this.getMana() <= 10) continue;
            this.addMana(-10);
            float convertedPitch = (float)Math.pow(2.0, (double)(note - 12 + this.pitchShift) / 12.0);
            this.f_58857_.m_5594_(null, noteblockPos, inst.m_61668_(), SoundSource.RECORDS, 3.0f, convertedPitch);
        }
        return true;
    }

    public boolean acceptsRedstone() {
        return true;
    }

    public void readFromPacketNBT(CompoundTag tag) {
        super.readFromPacketNBT(tag);
        this.clock = tag.m_128451_("Clock");
    }

    public void writeToPacketNBT(CompoundTag tag) {
        super.writeToPacketNBT(tag);
        tag.m_128405_("Clock", this.clock);
    }

    public int getMaxMana() {
        return 2000;
    }

    public int getColor() {
        return 0xBB4422;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)this.range);
    }
}

