/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.block.entity;

import agency.highlysuspect.incorporeal.Inc;
import agency.highlysuspect.incorporeal.IncBlockEntityTypes;
import agency.highlysuspect.incorporeal.IncItems;
import agency.highlysuspect.incorporeal.corporea.IndexFinder;
import agency.highlysuspect.incorporeal.corporea.SolidifiedRequest;
import agency.highlysuspect.incorporeal.net.SanvocaliaEffect;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;

public class SanvocaliaBlockEntity
extends TileEntityFunctionalFlower {
    private final int radius;
    private int cooldown;
    @Nullable
    private UUID placerUuid = null;
    @Nullable
    private Component name = null;
    private static final UUID CHAT_SEND_UUID = UUID.fromString("00000000-0000-0000-0000-000000000069");
    private static final int CHAT_COST = 100;
    private static final int REDEEM_COST = 20;

    public SanvocaliaBlockEntity(int radius, BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.radius = radius;
    }

    public static SanvocaliaBlockEntity big(BlockPos pos, BlockState state) {
        return new SanvocaliaBlockEntity(3, IncBlockEntityTypes.SANVOCALIA_BIG, pos, state);
    }

    public static SanvocaliaBlockEntity small(BlockPos pos, BlockState state) {
        return new SanvocaliaBlockEntity(1, IncBlockEntityTypes.SANVOCALIA_SMALL, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        BlockPos pos = this.getEffectivePos();
        AABB itemDetectionBox = new AABB(pos.m_142082_(-this.radius, 0, -this.radius), pos.m_142082_(this.radius + 1, 1, this.radius + 1));
        List nearbyTicketEnts = this.f_58857_.m_6443_(ItemEntity.class, itemDetectionBox, ent -> {
            if (ent == null || !ent.m_6084_()) {
                return false;
            }
            ItemStack stack = ent.m_32055_();
            return !stack.m_41619_() && stack.m_41720_() == IncItems.SOLIDIFIED_REQUEST_TICKET && !IncItems.SOLIDIFIED_REQUEST_TICKET.get(stack).isEmpty();
        });
        if (nearbyTicketEnts.isEmpty()) {
            return;
        }
        ItemEntity ticketEnt = (ItemEntity)Inc.choose(nearbyTicketEnts, this.f_58857_.m_5822_());
        SolidifiedRequest request = (SolidifiedRequest)IncItems.SOLIDIFIED_REQUEST_TICKET.get(ticketEnt.m_32055_()).castAndGet();
        List<TileCorporeaIndex> nearbyIndices = IndexFinder.findNearBlock(this.f_58857_, pos);
        if (nearbyIndices.isEmpty()) {
            MinecraftServer server = this.f_58857_.m_142572_();
            if (server != null && this.getMana() >= 100) {
                ServerPlayer player;
                TranslatableComponent msg = new TranslatableComponent("chat.type.text", new Object[]{this.name == null ? new TranslatableComponent("block.incorporeal.sanvocalia") : this.name, request.toComponent()});
                Inc.LOGGER.info("Sanvocalia message triggered at {} in dimension {}", (Object)pos.m_123344_(), (Object)this.f_58857_.m_46472_().m_135782_().toString());
                if (Inc.INSTANCE.config.everyoneHearsSanvocalia()) {
                    server.m_6846_().m_11264_((Component)msg, ChatType.CHAT, CHAT_SEND_UUID);
                } else if (this.placerUuid != null && (player = server.m_6846_().m_11259_(this.placerUuid)) != null) {
                    player.m_6352_((Component)msg, CHAT_SEND_UUID);
                }
                this.addMana(-100);
                this.consumeTicket(ticketEnt, null);
                this.cooldown = 3;
                this.sync();
            }
        } else {
            boolean didAnything = false;
            HashSet<BlockPos> indexPositions = new HashSet<BlockPos>();
            for (TileCorporeaIndex index : nearbyIndices) {
                if (this.getMana() < 20) break;
                this.addMana(-20);
                index.doCorporeaRequest(request.matcher(), request.count(), index.getSpark());
                indexPositions.add(index.m_58899_());
                didAnything = true;
            }
            if (didAnything) {
                this.consumeTicket(ticketEnt, indexPositions);
                this.cooldown = 3;
                this.sync();
            }
        }
    }

    private void consumeTicket(ItemEntity ticket, @Nullable Set<BlockPos> indexPositions) {
        Preconditions.checkNotNull((Object)this.f_58857_);
        Preconditions.checkArgument((!this.f_58857_.m_5776_() ? 1 : 0) != 0, (Object)"call on server level only pls.");
        ServerLevel levelS = (ServerLevel)this.f_58857_;
        BlockPos pos = this.getEffectivePos();
        SoundEvent evt = this.f_58857_.m_5822_().nextInt(10) == 0 ? SoundEvents.f_12321_ : SoundEvents.f_11912_;
        this.f_58857_.m_5594_(null, pos, evt, SoundSource.BLOCKS, 0.5f, 1.0f);
        levelS.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, ticket.m_32055_()), ticket.m_20185_(), ticket.m_20186_(), ticket.m_20189_(), 1, 0.0, 0.1, 0.0, 0.03);
        if (indexPositions != null && !indexPositions.isEmpty()) {
            new SanvocaliaEffect(ticket.m_20182_(), indexPositions).sendToAllWatching(levelS, pos);
        }
        if (ticket.m_32055_().m_41613_() > 1) {
            ticket.m_32055_().m_41774_(1);
            ticket.m_32045_(ticket.m_32055_());
        } else {
            ticket.m_146870_();
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        UUID uUID = this.placerUuid = placer == null ? null : placer.m_142081_();
        if (stack.m_41788_()) {
            this.name = stack.m_41786_();
        }
    }

    public void readFromPacketNBT(CompoundTag tag) {
        super.readFromPacketNBT(tag);
        this.placerUuid = tag.m_128441_("Placer") ? tag.m_128342_("Placer") : null;
        this.name = tag.m_128441_("Name") ? Component.Serializer.m_130701_((String)tag.m_128461_("Name")) : null;
        this.cooldown = tag.m_128451_("Cooldown");
    }

    public void writeToPacketNBT(CompoundTag tag) {
        super.writeToPacketNBT(tag);
        if (this.placerUuid != null) {
            tag.m_128362_("Placer", this.placerUuid);
        }
        if (this.name != null) {
            tag.m_128359_("Name", Component.Serializer.m_130703_((Component)this.name));
        }
        tag.m_128405_("Cooldown", this.cooldown);
    }

    public int getMaxMana() {
        return 200;
    }

    public int getColor() {
        return 15570469;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)this.radius);
    }
}

