/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.client;

import agency.highlysuspect.incorporeal.net.DataFunnelEffect;
import agency.highlysuspect.incorporeal.net.FunnyEffect;
import agency.highlysuspect.incorporeal.net.SanvocaliaEffect;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.proxy.IProxy;

public class IncClientNetwork {
    public static Byte2ObjectMap<BiConsumer<Minecraft, FriendlyByteBuf>> handlers = new Byte2ObjectOpenHashMap();

    public static void doParticleBeamSingleColor(Level world, Vec3 orig, Vec3 end, int color, double spacing, float size) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Vec3 diff = end.m_82546_(orig);
        Vec3 movement = diff.m_82541_().m_82490_(spacing);
        int iters = (int)(diff.m_82553_() / movement.m_82553_());
        Vec3 currentPos = orig;
        for (int i = 0; i < iters; ++i) {
            SparkleParticleData data = SparkleParticleData.noClip((float)size, (float)r, (float)g, (float)b, (int)4);
            IProxy.INSTANCE.addParticleForceNear(world, (ParticleOptions)data, currentPos.f_82479_, currentPos.f_82480_, currentPos.f_82481_, 0.0, 0.0, 0.0);
            currentPos = currentPos.m_82549_(movement);
        }
    }

    public static void initialize() {
    }

    public static void handle(FriendlyByteBuf buf) {
        byte which = buf.readByte();
        BiConsumer handler = (BiConsumer)handlers.get(which);
        if (handler != null) {
            handler.accept(Minecraft.m_91087_(), buf);
        }
    }

    static {
        handlers.put((byte)0, (mc, buf) -> {
            FunnyEffect effect = FunnyEffect.unpack(buf);
            mc.m_6367_(() -> {
                ClientLevel level = mc.f_91073_;
                if (level == null) {
                    return;
                }
                BlockPos srcPos = effect.src();
                double sparkleHeight = effect.sparkleHeight();
                Vec3 src = level.m_8055_(srcPos).m_60824_((BlockGetter)level, srcPos).m_82520_((double)srcPos.m_123341_() + 0.5, (double)srcPos.m_123342_() + sparkleHeight, (double)srcPos.m_123343_() + 0.5);
                for (FunnyEffect.Line line : effect.lines()) {
                    Vec3 dst = Vec3.m_82512_((Vec3i)line.dst());
                    ItemTwigWand.doParticleBeam((Level)level, (Vec3)src, (Vec3)dst);
                    byte[] notes = line.notes();
                    if (notes.length == 1) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, dst.f_82479_, dst.f_82480_ + 0.7, dst.f_82481_, (double)notes[0] / 24.0, 0.0, 0.0);
                        continue;
                    }
                    if (notes.length != 2) continue;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, dst.f_82479_ - 0.2, dst.f_82480_ + 0.7, dst.f_82481_, (double)notes[0] / 24.0, 0.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, dst.f_82479_ + 0.2, dst.f_82480_ + 0.7, dst.f_82481_, (double)notes[1] / 24.0, 0.0, 0.0);
                }
            });
        });
        handlers.put((byte)1, (mc, buf) -> {
            SanvocaliaEffect effect = SanvocaliaEffect.unpack(buf);
            mc.m_6367_(() -> {
                ClientLevel level = mc.f_91073_;
                if (level == null) {
                    return;
                }
                for (BlockPos dst : effect.ends()) {
                    ItemTwigWand.doParticleBeam((Level)level, (Vec3)effect.start(), (Vec3)Vec3.m_82512_((Vec3i)dst));
                }
            });
        });
        handlers.put((byte)2, (mc, buf) -> {
            DataFunnelEffect effect = DataFunnelEffect.unpack(buf);
            mc.m_6367_(() -> {
                ClientLevel level = mc.f_91073_;
                if (level == null) {
                    return;
                }
                for (DataFunnelEffect.Line line : effect.lines()) {
                    IncClientNetwork.doParticleBeamSingleColor((Level)level, line.start(), line.end(), line.color(), 0.2, 2.0f);
                }
            });
        });
    }
}

