/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.client;

import agency.highlysuspect.incorporeal.Inc;
import agency.highlysuspect.incorporeal.IncBlockEntityTypes;
import agency.highlysuspect.incorporeal.IncBlocks;
import agency.highlysuspect.incorporeal.IncEntityTypes;
import agency.highlysuspect.incorporeal.IncItems;
import agency.highlysuspect.incorporeal.block.PetalCarpetBlock;
import agency.highlysuspect.incorporeal.block.UnstableCubeBlock;
import agency.highlysuspect.incorporeal.block.entity.AbstractSoulCoreBlockEntity;
import agency.highlysuspect.incorporeal.client.DataFunnelBlockEntityRenderer;
import agency.highlysuspect.incorporeal.client.MyDynamicItemRenderer;
import agency.highlysuspect.incorporeal.client.SoulCoreRenderers;
import agency.highlysuspect.incorporeal.client.UnstableCubeRenderers;
import agency.highlysuspect.incorporeal.computer.types.DataTypes;
import agency.highlysuspect.incorporeal.computer.types.Datum;
import agency.highlysuspect.incorporeal.item.TicketItem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.client.render.ColorHandler;
import vazkii.botania.client.render.entity.EntityRenderers;
import vazkii.botania.client.render.tile.RenderTileRedString;
import vazkii.botania.client.render.tile.RenderTileSpecialFlower;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.network.TriConsumer;
import vazkii.botania.xplat.IXplatAbstractions;

public class IncClientProperties {
    public static final Map<Item, Supplier<MyDynamicItemRenderer>> MY_DYNAMIC_ITEM_RENDERERS = new HashMap<Item, Supplier<MyDynamicItemRenderer>>();
    private static final ResourceLocation SOUL_CORE_FRAME_MODEL = Inc.id("block/soul_core_frame");
    public static final Map<BlockEntityType<?>, Function<BlockEntity, IWandHUD>> WAND_HUD_MAKERS;

    public static void registerExtraModelsToBake(Consumer<ResourceLocation> r) {
        r.accept(SOUL_CORE_FRAME_MODEL);
    }

    public static void registerRenderTypes(BiConsumer<Block, RenderType> r) {
        RenderType cutout = RenderType.m_110463_();
        RenderType translucent = RenderType.m_110466_();
        r.accept((Block)IncBlocks.NATURAL_REPEATER, cutout);
        r.accept((Block)IncBlocks.NATURAL_COMPARATOR, cutout);
        r.accept((Block)IncBlocks.REDSTONE_ROOT_CROP, cutout);
        r.accept((Block)IncBlocks.ENDER_SOUL_CORE, translucent);
        r.accept((Block)IncBlocks.POTION_SOUL_CORE, translucent);
        r.accept((Block)IncBlocks.SANVOCALIA, cutout);
        r.accept((Block)IncBlocks.SANVOCALIA_SMALL, cutout);
        r.accept((Block)IncBlocks.FLOATING_SANVOCALIA, cutout);
        r.accept((Block)IncBlocks.FLOATING_SANVOCALIA_SMALL, cutout);
        r.accept((Block)IncBlocks.FUNNY, cutout);
        r.accept((Block)IncBlocks.FUNNY_SMALL, cutout);
        r.accept((Block)IncBlocks.FLOATING_FUNNY, cutout);
        r.accept((Block)IncBlocks.FLOATING_FUNNY_SMALL, cutout);
        for (Block block : IncBlocks.COMPRESSED_TATERS.values()) {
            r.accept(block, cutout);
        }
        r.accept(IncBlocks.DATA_FUNNEL, translucent);
        r.accept((Block)IncBlocks.DATASTONE_BLOCK, translucent);
        r.accept((Block)IncBlocks.POINTED_DATASTONE, translucent);
    }

    public static void registerBlockEntityRenderers(EntityRenderers.BERConsumer r) {
        r.register(IncBlockEntityTypes.RED_STRING_LIAR, RenderTileRedString::new);
        r.register(IncBlockEntityTypes.RED_STRING_CONSTRICTOR, RenderTileRedString::new);
        r.register(IncBlockEntityTypes.ENDER_SOUL_CORE, SoulCoreRenderers::createBlockEntityRenderer);
        r.register(IncBlockEntityTypes.POTION_SOUL_CORE, SoulCoreRenderers::createBlockEntityRenderer);
        r.register(IncBlockEntityTypes.SANVOCALIA_BIG, RenderTileSpecialFlower::new);
        r.register(IncBlockEntityTypes.SANVOCALIA_SMALL, RenderTileSpecialFlower::new);
        r.register(IncBlockEntityTypes.FUNNY_BIG, RenderTileSpecialFlower::new);
        r.register(IncBlockEntityTypes.FUNNY_SMALL, RenderTileSpecialFlower::new);
        r.register(IncBlockEntityTypes.UNSTABLE_CUBE, UnstableCubeRenderers::createBlockEntityRenderer);
        r.register(IncBlockEntityTypes.DATA_FUNNEL, DataFunnelBlockEntityRenderer::new);
    }

    public static void registerBlockColorProviders(ColorHandler.BlockHandlerConsumer r) {
        r.register((state, level, pos, tintIndex) -> {
            Block patt5528$temp = state.m_60734_();
            if (patt5528$temp instanceof UnstableCubeBlock) {
                UnstableCubeBlock cube = (UnstableCubeBlock)patt5528$temp;
                return cube.color.m_41070_();
            }
            return 0xFFFFFF;
        }, (Block[])IncBlocks.UNSTABLE_CUBES.values().toArray(Block[]::new));
        r.register((state, level, pos, tintIndex) -> {
            Block patt5787$temp = state.m_60734_();
            if (patt5787$temp instanceof PetalCarpetBlock) {
                PetalCarpetBlock carpet = (PetalCarpetBlock)patt5787$temp;
                return ColorHelper.getColorValue((DyeColor)carpet.m_58309_());
            }
            return 0xFFFFFF;
        }, (Block[])IncBlocks.PETAL_CARPETS.values().toArray(Block[]::new));
    }

    public static void registerItemColorProviders(ColorHandler.ItemHandlerConsumer r) {
        r.register((stack, tintIndex) -> {
            if (tintIndex != 0) {
                return 0xFFFFFF;
            }
            if (IncItems.BOUND_ENDER_PEARL.getOwnerUuid(stack) == null) {
                return 0x777777;
            }
            IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
            if (manaItem == null || manaItem.getMaxMana() == 0) {
                return 0xFF0000;
            }
            float percentageFull = (float)manaItem.getMana() / (float)manaItem.getMaxMana();
            percentageFull = Mth.m_14036_((float)percentageFull, (float)0.0f, (float)1.0f);
            return Mth.m_14169_((float)(percentageFull / 2.0f), (float)1.0f, (float)1.0f);
        }, new ItemLike[]{IncItems.BOUND_ENDER_PEARL});
        r.register((stack, tintIndex) -> ColorHelper.getColorValue((DyeColor)((PetalCarpetBlock)((BlockItem)stack.m_41720_()).m_40614_()).m_58309_()), (ItemLike[])IncItems.PETAL_CARPETS.values().toArray(BlockItem[]::new));
    }

    public static void registerPropertyOverrides(TriConsumer<ItemLike, ResourceLocation, ItemPropertyFunction> r) {
        for (TicketItem<?> ticket : DataTypes.allTicketItems()) {
            r.accept(ticket, (Object)Inc.id("written_ticket"), (stack, level, ent, seed) -> {
                Datum<?> datum = ticket.get(stack);
                if (datum.type() == DataTypes.EMPTY) {
                    return stack.m_41782_() ? 1.0f : 0.0f;
                }
                return datum.isEmpty() ? 0.0f : 1.0f;
            });
        }
        r.accept((Object)IncItems.BOUND_ENDER_PEARL, (Object)Inc.id("is_bound"), (stack, level, ent, seed) -> IncItems.BOUND_ENDER_PEARL.getOwnerUuid(stack) == null ? 0.0f : 1.0f);
    }

    public static void registerEntityRenderers(EntityRenderers.EntityRendererConsumer r) {
        r.accept(IncEntityTypes.FRACTURED_SPACE_COLLECTOR, NoopRenderer::new);
        r.accept(IncEntityTypes.POTION_SOUL_CORE_COLLECTOR, NoopRenderer::new);
    }

    private static IWandHUD soulCoreHudDowncast(BlockEntity be) {
        return new AbstractSoulCoreBlockEntity.WandHud((AbstractSoulCoreBlockEntity)be);
    }

    private static IWandHUD functionalFlowerHudDowncast(BlockEntity be) {
        return new TileEntityFunctionalFlower.FunctionalWandHud((TileEntityFunctionalFlower)be);
    }

    static {
        IncItems.UNSTABLE_CUBES.forEach((color, cube) -> MY_DYNAMIC_ITEM_RENDERERS.put((Item)cube, () -> UnstableCubeRenderers.createItemRenderer(color)));
        MY_DYNAMIC_ITEM_RENDERERS.put((Item)IncItems.ENDER_SOUL_CORE, () -> SoulCoreRenderers.createItemRenderer(IncBlocks.ENDER_SOUL_CORE.m_49966_()));
        MY_DYNAMIC_ITEM_RENDERERS.put((Item)IncItems.POTION_SOUL_CORE, () -> SoulCoreRenderers.createItemRenderer(IncBlocks.POTION_SOUL_CORE.m_49966_()));
        MY_DYNAMIC_ITEM_RENDERERS.put(IncItems.SOUL_CORE_FRAME, () -> SoulCoreRenderers.createItemRendererForNamedModel(SOUL_CORE_FRAME_MODEL));
        WAND_HUD_MAKERS = new HashMap();
        WAND_HUD_MAKERS.put(IncBlockEntityTypes.ENDER_SOUL_CORE, IncClientProperties::soulCoreHudDowncast);
        WAND_HUD_MAKERS.put(IncBlockEntityTypes.POTION_SOUL_CORE, IncClientProperties::soulCoreHudDowncast);
        WAND_HUD_MAKERS.put(IncBlockEntityTypes.SANVOCALIA_BIG, IncClientProperties::functionalFlowerHudDowncast);
        WAND_HUD_MAKERS.put(IncBlockEntityTypes.SANVOCALIA_SMALL, IncClientProperties::functionalFlowerHudDowncast);
        WAND_HUD_MAKERS.put(IncBlockEntityTypes.FUNNY_BIG, IncClientProperties::functionalFlowerHudDowncast);
        WAND_HUD_MAKERS.put(IncBlockEntityTypes.FUNNY_SMALL, IncClientProperties::functionalFlowerHudDowncast);
    }
}

