/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.client;

import agency.highlysuspect.incorporeal.Inc;
import agency.highlysuspect.incorporeal.IncBlocks;
import agency.highlysuspect.incorporeal.block.entity.AbstractSoulCoreBlockEntity;
import agency.highlysuspect.incorporeal.client.MyDynamicItemRenderer;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.mixin.client.AccessorModelManager;

public class SoulCoreRenderers {
    protected final SkullModelBase playerSkullModel;

    public static <T extends AbstractSoulCoreBlockEntity> BlockEntityRenderer<T> createBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        return new BlockEntity(ctx);
    }

    public static MyDynamicItemRenderer createItemRenderer(BlockState state) {
        return new Item(state, Minecraft.m_91087_().m_91289_(), Minecraft.m_91087_().m_167973_());
    }

    public static MyDynamicItemRenderer createItemRendererForNamedModel(ResourceLocation modelLocation) {
        return new Item(modelLocation, Minecraft.m_91087_().m_91304_(), Minecraft.m_91087_().m_167973_());
    }

    protected SoulCoreRenderers(EntityModelSet modelSet) {
        this.playerSkullModel = new SkullModel(modelSet.m_171103_(ModelLayers.f_171163_));
    }

    protected void initialWobble(PoseStack pose, int hash, float ticks) {
        pose.m_85845_(Vector3f.f_122225_.m_122240_(((float)hash + ticks) * 2.0f % 360.0f));
        pose.m_85837_(0.0, 0.1 * (double)Inc.sinDegrees(((float)hash + ticks) * 4.0f), 0.0);
    }

    protected void drawSkull(PoseStack pose, int hash, float ticks, MultiBufferSource bufs, int light, int overlay, GameProfile skullProfile) {
        pose.m_85836_();
        pose.m_85841_(0.875f, 0.875f, 0.875f);
        float wobble = ((float)hash + ticks) * 5.0f;
        float wobbleSin = Inc.sinDegrees(wobble);
        float wobbleCos = Inc.cosDegrees(wobble);
        float wobbleAmountDegrees = 10.0f;
        pose.m_85845_(Vector3f.f_122223_.m_122240_(wobbleCos * wobbleAmountDegrees));
        pose.m_85845_(Vector3f.f_122223_.m_122240_(wobbleSin * wobbleAmountDegrees));
        pose.m_85845_(Vector3f.f_122227_.m_122240_(-wobbleCos * wobbleAmountDegrees));
        pose.m_85845_(Vector3f.f_122227_.m_122240_(-wobbleSin * wobbleAmountDegrees));
        pose.m_85837_(0.0, -0.25, 0.0);
        pose.m_85841_(-1.0f, -1.0f, 1.0f);
        VertexConsumer buffer = bufs.m_6299_(SkullBlockRenderer.m_112523_((SkullBlock.Type)SkullBlock.Types.PLAYER, (GameProfile)skullProfile));
        this.playerSkullModel.m_7695_(pose, buffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85849_();
    }

    protected void drawCubes(PoseStack pose, int hash, float ticks, MultiBufferSource bufs, int light, int overlay, BlockState state, BakedModel model) {
        pose.m_85836_();
        pose.m_85845_(Vector3f.f_122225_.m_122240_((-ticks + (float)hash) / 5.0f % 360.0f));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14031_((float)((ticks + (float)hash) / 50.0f)) * 40.0f));
        float wobble2 = ((float)hash + ticks) * 3.0f;
        float wobble2Sin = Inc.sinDegrees(wobble2);
        float wobble2Cos = Inc.cosDegrees(wobble2);
        float wobble2AmountDegrees = 10.0f;
        pose.m_85845_(Vector3f.f_122223_.m_122240_(-wobble2Cos * wobble2AmountDegrees));
        pose.m_85845_(Vector3f.f_122223_.m_122240_(-wobble2Sin * wobble2AmountDegrees));
        pose.m_85845_(Vector3f.f_122227_.m_122240_(wobble2Cos * wobble2AmountDegrees));
        pose.m_85845_(Vector3f.f_122227_.m_122240_(wobble2Sin * wobble2AmountDegrees));
        pose.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer buffer = bufs.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)false));
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(pose.m_85850_(), buffer, state, model, 1.0f, 1.0f, 1.0f, light, overlay);
        pose.m_85849_();
    }

    private static class BlockEntity<T extends AbstractSoulCoreBlockEntity>
    extends SoulCoreRenderers
    implements BlockEntityRenderer<T> {
        public BlockEntity(BlockEntityRendererProvider.Context ctx) {
            super(ctx.m_173585_());
        }

        public void render(@NotNull T core, float partialTicks, PoseStack pose, MultiBufferSource bufs, int light, int overlay) {
            int hash = Mth.m_14183_((int)core.m_58899_().hashCode()) & 0xFFFF;
            float ticks = ClientTickHandler.total();
            BlockState state = core.m_58900_();
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
            pose.m_85836_();
            pose.m_85837_(0.5, 0.5, 0.5);
            this.initialWobble(pose, hash, ticks);
            if (((AbstractSoulCoreBlockEntity)((Object)core)).hasOwnerProfile()) {
                this.drawSkull(pose, hash, ticks, bufs, light, overlay, ((AbstractSoulCoreBlockEntity)((Object)core)).getOwnerProfile());
            }
            this.drawCubes(pose, hash, ticks, bufs, light, overlay, state, model);
            pose.m_85849_();
        }
    }

    private static class Item
    extends SoulCoreRenderers
    implements MyDynamicItemRenderer {
        private final BlockState state;
        private final BakedModel model;

        public Item(BlockState state, BlockRenderDispatcher dispatcher, EntityModelSet modelSet) {
            super(modelSet);
            this.state = state;
            this.model = dispatcher.m_110910_(state);
        }

        public Item(ResourceLocation modelLocation, ModelManager modelManager, EntityModelSet modelSet) {
            super(modelSet);
            Map modelMap = ((AccessorModelManager)modelManager).getBakedRegistry();
            this.model = modelMap.getOrDefault(modelLocation, modelManager.m_119409_());
            this.state = IncBlocks.ENDER_SOUL_CORE.m_49966_();
        }

        @Override
        public void render(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack pose, MultiBufferSource bufs, int light, int overlay) {
            float ticks = ClientTickHandler.total();
            pose.m_85836_();
            pose.m_85837_(0.52, 0.5, 0.5);
            this.initialWobble(pose, 0, ticks);
            this.drawCubes(pose, 0, ticks, bufs, light, overlay, this.state, this.model);
            pose.m_85849_();
        }
    }
}

