/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.client;

import agency.highlysuspect.incorporeal.Inc;
import agency.highlysuspect.incorporeal.IncBlocks;
import agency.highlysuspect.incorporeal.block.UnstableCubeBlock;
import agency.highlysuspect.incorporeal.block.entity.UnstableCubeBlockEntity;
import agency.highlysuspect.incorporeal.client.MyDynamicItemRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.handler.ClientTickHandler;

public abstract class UnstableCubeRenderers {
    private static final Vector3f XZP;

    public static BlockEntityRenderer<UnstableCubeBlockEntity> createBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        return new BlockEntity();
    }

    public static MyDynamicItemRenderer createItemRenderer(DyeColor color) {
        return new Item(color);
    }

    protected void drawCube(BlockState state, BakedModel model, PoseStack pose, MultiBufferSource bufs, int light, int overlay, float red, float green, float blue) {
        VertexConsumer buffer = bufs.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)false));
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(pose.m_85850_(), buffer, state, model, red, green, blue, light, overlay);
    }

    protected static void roll(PoseStack pose, float partialTicks, float angle, float speed, float bump, float bumpDecay, int hash, float bonusExtraScaling) {
        float ticks = (float)ClientTickHandler.ticksInGame + partialTicks;
        float predictedAngle = angle + speed * partialTicks;
        float predictedBump = bump * Inc.rangeRemap(partialTicks, 0.0f, 1.0f, bump, bump * bumpDecay);
        int flip = (hash & 1) == 0 ? -1 : 1;
        pose.m_85837_(0.5, 0.5, 0.5);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(((float)flip * predictedAngle + (float)hash) % 360.0f));
        float wobble = ticks + (float)hash;
        float wobbleSin = Inc.sinDegrees(wobble);
        float wobbleCos = Inc.cosDegrees(wobble);
        float wobbleAmountDegrees = 15 * flip;
        pose.m_85845_(XZP.m_122240_(Mth.m_14031_((float)((float)hash + ticks * 0.02f)) * 40.0f * (float)flip));
        pose.m_85845_(Vector3f.f_122223_.m_122240_(wobbleCos * wobbleAmountDegrees));
        pose.m_85845_(Vector3f.f_122223_.m_122240_(wobbleSin * wobbleAmountDegrees));
        pose.m_85845_(Vector3f.f_122227_.m_122240_(-wobbleSin * wobbleAmountDegrees));
        pose.m_85845_(Vector3f.f_122227_.m_122240_(-wobbleCos * wobbleAmountDegrees));
        float upscale = predictedBump * 0.7f + 1.0f + bonusExtraScaling;
        pose.m_85841_(upscale, upscale, upscale);
        pose.m_85837_(-0.5, -0.5, -0.5);
    }

    static {
        Vector3f xp = Vector3f.f_122223_.m_122281_();
        xp.m_122253_(Vector3f.f_122227_);
        xp.m_122278_();
        XZP = xp;
    }

    private static class BlockEntity
    extends UnstableCubeRenderers
    implements BlockEntityRenderer<UnstableCubeBlockEntity> {
        private BlockEntity() {
        }

        public void render(@NotNull UnstableCubeBlockEntity cube, float partialTicks, PoseStack pose, MultiBufferSource bufs, int light, int overlay) {
            pose.m_85836_();
            BlockState state = cube.m_58900_();
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
            UnstableCubeBlock block = (UnstableCubeBlock)state.m_60734_();
            int colorPacked = block.color.m_41070_();
            float red = (float)((colorPacked & 0xFF0000) >> 16) / 255.0f;
            float green = (float)((colorPacked & 0xFF00) >> 8) / 255.0f;
            float blue = (float)(colorPacked & 0xFF) / 255.0f;
            int hash = Mth.m_14183_((int)cube.m_58899_().hashCode()) & 0xFFFF;
            BlockEntity.roll(pose, partialTicks, cube.angle, cube.speed, cube.bump, cube.bumpDecay, hash, 0.0f);
            this.drawCube(state, model, pose, bufs, light, overlay, red, green, blue);
            pose.m_85849_();
        }
    }

    private static class Item
    extends UnstableCubeRenderers
    implements MyDynamicItemRenderer {
        private final BlockState state;
        private final BakedModel model;
        private final float rotationOffset;
        private final float red;
        private final float green;
        private final float blue;

        public Item(DyeColor color) {
            this.state = IncBlocks.UNSTABLE_CUBES.get(color).m_49966_();
            this.model = Minecraft.m_91087_().m_91289_().m_110910_(this.state);
            this.rotationOffset = (float)Math.toDegrees((float)color.ordinal() * 2.5f);
            int colorPacked = color.m_41070_();
            this.red = (float)((colorPacked & 0xFF0000) >> 16) / 255.0f;
            this.green = (float)((colorPacked & 0xFF00) >> 8) / 255.0f;
            this.blue = (float)(colorPacked & 0xFF) / 255.0f;
        }

        @Override
        public void render(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack pose, MultiBufferSource bufs, int light, int overlay) {
            pose.m_85836_();
            Item.roll(pose, ClientTickHandler.total(), this.rotationOffset, 0.0f, 0.0f, 0.0f, 0, 0.4f);
            this.drawCube(this.state, this.model, pose, bufs, light, overlay, this.red, this.green, this.blue);
            pose.m_85849_();
        }
    }
}

