/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.client.computer;

import agency.highlysuspect.incorporeal.IncTags;
import agency.highlysuspect.incorporeal.client.computer.DatumRenderers;
import agency.highlysuspect.incorporeal.computer.capabilities.DataLensProvider;
import agency.highlysuspect.incorporeal.computer.capabilities.DatumAcceptor;
import agency.highlysuspect.incorporeal.computer.capabilities.DatumProvider;
import agency.highlysuspect.incorporeal.computer.capabilities.NotCapabilities;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.common.handler.EquipmentHandler;

public class DataseerMonocleHudHandler {
    public static void doIt(PoseStack pose, float partialTicks) {
        List<Entity> entitiesInTheBlockspace;
        BlockEntity be;
        BlockState state;
        BlockPos pos;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !DataseerMonocleHudHandler.hasDataseerMonocle((LivingEntity)player)) {
            return;
        }
        Level level = player.f_19853_;
        HitResult ray = mc.f_91077_;
        if (ray == null || ray.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        if (ray.m_6662_() == HitResult.Type.BLOCK && ray instanceof BlockHitResult) {
            BlockHitResult bhr = (BlockHitResult)ray;
            pos = bhr.m_82425_();
            state = level.m_8055_(pos);
            be = level.m_7702_(pos);
            entitiesInTheBlockspace = Collections.emptyList();
        } else if (ray.m_6662_() == HitResult.Type.ENTITY && ray instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)ray;
            pos = new BlockPos(ray.m_82450_());
            state = null;
            be = null;
            entitiesInTheBlockspace = List.of(ehr.m_82443_());
        } else {
            return;
        }
        @Nullable DatumProvider provider = NotCapabilities.findDatumProvider(level, pos, state, be, entitiesInTheBlockspace, true);
        @Nullable DatumAcceptor acceptor = NotCapabilities.findDatumAcceptor(level, pos, state, be, entitiesInTheBlockspace, true);
        @Nullable DataLensProvider lensProvider = NotCapabilities.findDataLensProvider(level, pos, state, be, true);
        if (provider == null && acceptor == null && lensProvider == null) {
            return;
        }
        int halfwidth = mc.m_91268_().m_85445_() / 2;
        int halfheight = mc.m_91268_().m_85446_() / 2;
        if (provider != null) {
            pose.m_85836_();
            pose.m_85837_((double)halfwidth, (double)(halfheight - 50), 0.0);
            DatumRenderers.draw(mc, pose, partialTicks, provider.readDatum(false));
            pose.m_85849_();
        }
        if (acceptor != null) {
            DatumRenderers.drawCentered(mc, pose, (Component)new TextComponent("Can accept"), halfwidth, halfheight - 35, 0xFF8800);
        }
        if (lensProvider != null) {
            ItemStack wow = lensProvider.hahaOopsLeakyAbstraction();
            Component yea = wow.m_41786_();
            DatumRenderers.drawCentered(mc, pose, yea, halfwidth, halfheight - 20, 35071);
        }
    }

    public static boolean hasDataseerMonocle(LivingEntity living) {
        return !EquipmentHandler.findOrEmpty(stack -> {
            if (!stack.m_41619_()) {
                Item item = stack.m_41720_();
                if (stack.m_204117_(IncTags.Items.DATA_VIEWERS)) {
                    return true;
                }
                if (item instanceof ICosmeticAttachable) {
                    ICosmeticAttachable attach = (ICosmeticAttachable)item;
                    ItemStack cosmetic = attach.getCosmeticItem(stack);
                    return !cosmetic.m_41619_() && cosmetic.m_204117_(IncTags.Items.DATA_VIEWERS);
                }
            }
            return false;
        }, (LivingEntity)living).m_41619_();
    }
}

