/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.computer;

import agency.highlysuspect.incorporeal.computer.capabilities.DataLensProvider;
import agency.highlysuspect.incorporeal.computer.capabilities.DatumAcceptor;
import agency.highlysuspect.incorporeal.computer.capabilities.DatumProvider;
import agency.highlysuspect.incorporeal.computer.capabilities.NotCapabilities;
import agency.highlysuspect.incorporeal.computer.types.DataLens;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DataRayClipContext {
    public final ServerLevel level;
    public final BlockPos start;
    public final BlockPos end;
    public final List<Pairing> pairings = new ArrayList<Pairing>(4);
    @Nullable
    public ProviderEntry unpairedProvider;

    public DataRayClipContext(ServerLevel level, BlockPos start, BlockPos end) {
        this.level = level;
        this.start = start;
        this.end = end;
    }

    public static DataRayClipContext performClip(ServerLevel level, BlockPos start, BlockPos end) {
        return (DataRayClipContext)BlockGetter.m_151361_((Vec3)Vec3.m_82512_((Vec3i)start), (Vec3)Vec3.m_82512_((Vec3i)end), (Object)new DataRayClipContext(level, start, end), DataRayClipContext::step, Function.identity());
    }

    public DataRayClipContext step(BlockPos cursor) {
        BlockEntity be = this.level.m_7702_(cursor);
        BlockState state = be == null ? null : be.m_58900_();
        boolean isDirectBinding = this.start.equals((Object)cursor);
        List entitiesInTheBlockspace = this.level.m_45933_(null, new AABB(cursor));
        @Nullable DatumAcceptor acceptor = NotCapabilities.findDatumAcceptor((Level)this.level, cursor, state, be, entitiesInTheBlockspace, isDirectBinding);
        @Nullable DatumProvider provider = NotCapabilities.findDatumProvider((Level)this.level, cursor, state, be, entitiesInTheBlockspace, isDirectBinding);
        @Nullable DataLensProvider lensProvider = NotCapabilities.findDataLensProvider((Level)this.level, cursor, state, be, isDirectBinding);
        if (this.unpairedProvider != null) {
            if (lensProvider != null) {
                LensEntry lensEntry = new LensEntry(lensProvider.getLens(), lensProvider.tweakPosition((Level)this.level, cursor));
                this.unpairedProvider.lenses.add(lensEntry);
            }
            if (acceptor != null) {
                AcceptorEntry acceptorEntry = new AcceptorEntry(acceptor, acceptor.tweakPosition((Level)this.level, cursor));
                this.pairings.add(new Pairing(this.unpairedProvider, acceptorEntry));
                this.unpairedProvider = null;
                return null;
            }
        }
        if (provider != null) {
            this.unpairedProvider = new ProviderEntry(provider, provider.tweakPosition((Level)this.level, cursor), new ArrayList<LensEntry>());
        }
        return null;
    }

    public record ProviderEntry(DatumProvider provider, Vec3 pos, ArrayList<LensEntry> lenses) {
    }

    public record LensEntry(DataLens lens, Vec3 pos) {
    }

    public record AcceptorEntry(DatumAcceptor acceptor, Vec3 pos) {
    }

    public record Pairing(ProviderEntry provider, AcceptorEntry acceptor) {
    }
}

