/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.computer.capabilities;

import agency.highlysuspect.incorporeal.IncBlocks;
import agency.highlysuspect.incorporeal.block.DatastoneBlock;
import agency.highlysuspect.incorporeal.computer.capabilities.DataLensProvider;
import agency.highlysuspect.incorporeal.computer.capabilities.DatumAcceptor;
import agency.highlysuspect.incorporeal.computer.capabilities.DatumProvider;
import agency.highlysuspect.incorporeal.computer.capabilities.PositionTweakable;
import agency.highlysuspect.incorporeal.computer.types.DataLens;
import agency.highlysuspect.incorporeal.computer.types.DataTypes;
import agency.highlysuspect.incorporeal.computer.types.Datum;
import agency.highlysuspect.incorporeal.corporea.RetainerDuck;
import agency.highlysuspect.incorporeal.corporea.SolidifiedRequest;
import agency.highlysuspect.incorporeal.item.NotManaLens;
import agency.highlysuspect.incorporeal.mixin.CorporeaItemStackMatcherAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.corporea.TileCorporeaCrystalCube;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.block.tile.mana.TilePrism;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.item.lens.Lens;

public class NotCapabilities {
    @Nullable
    public static DatumAcceptor findDatumAcceptor(Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity be, @Nullable List<Entity> entitiesInTheBlockspace, boolean directBind) {
        if (be == null) {
            be = level.m_7702_(pos);
        }
        if (be != null) {
            if (be instanceof DatumAcceptor) {
                DatumAcceptor acceptor = (DatumAcceptor)be;
                return acceptor;
            }
            if (be instanceof RetainerDuck) {
                RetainerDuck quack = (RetainerDuck)be;
                return datum -> {
                    if (datum.type() == DataTypes.EMPTY) {
                        quack.inc$setMatcher(null);
                        quack.inc$setCount(0);
                    } else if (datum.type() == DataTypes.INTEGER) {
                        quack.inc$setCount((Integer)datum.castAndGet());
                    } else if (datum.type() == DataTypes.MATCHER) {
                        quack.inc$setMatcher((ICorporeaRequestMatcher)datum.castAndGet());
                    } else if (datum.type() == DataTypes.SOLIDIFIED_REQUEST) {
                        quack.inc$liquifactRequest((SolidifiedRequest)datum.castAndGet());
                    }
                };
            }
            if (be instanceof TileCorporeaIndex) {
                TileCorporeaIndex index = (TileCorporeaIndex)be;
                return datum -> {
                    if (datum.type() == DataTypes.SOLIDIFIED_REQUEST) {
                        SolidifiedRequest request = (SolidifiedRequest)datum.castAndGet();
                        index.doCorporeaRequest(request.matcher(), request.count(), index.getSpark());
                    }
                };
            }
            if (be instanceof TileCorporeaCrystalCube) {
                TileCorporeaCrystalCube cube = (TileCorporeaCrystalCube)be;
                return datum -> {
                    ICorporeaRequestMatcher matcher;
                    if (datum.type() == DataTypes.EMPTY) {
                        cube.setRequestTarget(ItemStack.f_41583_);
                        return;
                    }
                    if (datum.type() == DataTypes.SOLIDIFIED_REQUEST) {
                        matcher = ((SolidifiedRequest)datum.castAndGet()).matcher();
                    } else if (datum.type() == DataTypes.MATCHER) {
                        matcher = (ICorporeaRequestMatcher)datum.castAndGet();
                    } else {
                        return;
                    }
                    if (matcher instanceof CorporeaItemStackMatcherAccessor) {
                        CorporeaItemStackMatcherAccessor ismAccessor = (CorporeaItemStackMatcherAccessor)matcher;
                        cube.setRequestTarget(ismAccessor.inc$getMatch());
                    }
                };
            }
        }
        if (state == null) {
            state = be != null ? be.m_58900_() : level.m_8055_(pos);
        }
        BlockState s = state;
        BlockPos posCopy = pos.m_7949_();
        if (s.m_60734_() == ModBlocks.manaVoid) {
            return datum -> {};
        }
        if (s.m_60734_() == IncBlocks.CORPOREA_SOLIDIFIER) {
            return datum -> IncBlocks.CORPOREA_SOLIDIFIER.receiveDatum(level, posCopy, datum);
        }
        Block block = s.m_60734_();
        if (block instanceof DatastoneBlock) {
            DatastoneBlock db = (DatastoneBlock)block;
            return datum -> db.extendColumn(level, posCopy, datum);
        }
        if (entitiesInTheBlockspace == null) {
            entitiesInTheBlockspace = level.m_45933_(null, new AABB(pos));
        }
        Collections.shuffle(entitiesInTheBlockspace, level.m_5822_());
        for (Entity ent : entitiesInTheBlockspace) {
            if (!(ent instanceof ItemFrame)) continue;
            ItemFrame frame = (ItemFrame)ent;
            return new FrameCaps(frame);
        }
        return null;
    }

    @Nullable
    public static DatumProvider findDatumProvider(Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity be, @Nullable List<Entity> entitiesInTheBlockspace, boolean directBind) {
        if (be == null) {
            be = level.m_7702_(pos);
        }
        if (be != null) {
            if (be instanceof DatumProvider) {
                DatumProvider provider = (DatumProvider)be;
                return provider;
            }
            if (be instanceof RetainerDuck) {
                RetainerDuck quack = (RetainerDuck)be;
                return doIt -> {
                    if (quack.inc$hasPendingRequest()) {
                        return DataTypes.SOLIDIFIED_REQUEST.datumOf(quack.inc$asSolidifiedRequest());
                    }
                    return Datum.EMPTY;
                };
            }
            if (be instanceof TileCorporeaCrystalCube) {
                TileCorporeaCrystalCube cube = (TileCorporeaCrystalCube)be;
                return doIt -> {
                    ItemStack target = cube.getRequestTarget();
                    if (target.m_41619_()) {
                        return Datum.EMPTY;
                    }
                    return DataTypes.SOLIDIFIED_REQUEST.datumOf(SolidifiedRequest.create(target, cube.getItemCount()));
                };
            }
            if (be instanceof ComparatorBlockEntity) {
                ComparatorBlockEntity comparator = (ComparatorBlockEntity)be;
                return doIt -> DataTypes.INTEGER.datumOf(comparator.m_59182_());
            }
        }
        if (state == null) {
            state = be != null ? be.m_58900_() : level.m_8055_(pos);
        }
        BlockState s = state;
        BlockPos posCopy = pos.m_7949_();
        if (s.m_60734_() == ModBlocks.manaVoid) {
            return doIt -> Datum.EMPTY;
        }
        Block block = s.m_60734_();
        if (block instanceof DatastoneBlock) {
            DatastoneBlock db = (DatastoneBlock)block;
            return doIt -> db.retractColumn(level, posCopy, doIt);
        }
        if (directBind) {
            Collection props = s.m_61147_();
            for (Property prop : props) {
                if (!(prop instanceof IntegerProperty)) continue;
                IntegerProperty intProp = (IntegerProperty)prop;
                return doIt -> DataTypes.INTEGER.datumOf((Integer)s.m_61143_((Property)intProp));
            }
            for (Property prop : props) {
                if (!(prop instanceof BooleanProperty)) continue;
                BooleanProperty boolProp = (BooleanProperty)prop;
                return doIt -> DataTypes.INTEGER.datumOf((Boolean)s.m_61143_((Property)boolProp) != false ? 1 : 0);
            }
        }
        if (entitiesInTheBlockspace == null) {
            entitiesInTheBlockspace = level.m_45933_(null, new AABB(pos));
        }
        Collections.shuffle(entitiesInTheBlockspace, level.m_5822_());
        for (Entity ent : entitiesInTheBlockspace) {
            if (!(ent instanceof ItemFrame)) continue;
            ItemFrame frame = (ItemFrame)ent;
            return new FrameCaps(frame);
        }
        return null;
    }

    @Nullable
    public static DataLensProvider findDataLensProvider(Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity be, boolean directBind) {
        TilePrism prism;
        Lens lens;
        if (be != null) {
            be = level.m_7702_(pos);
        }
        if (be instanceof TilePrism && (lens = ItemLens.getLens((ItemStack)(prism = (TilePrism)be).m_8020_(0))) instanceof NotManaLens) {
            final NotManaLens dataLens = (NotManaLens)lens;
            return new DataLensProvider(){

                @Override
                @NotNull
                public DataLens getLens() {
                    return dataLens.getDataLens();
                }

                @Override
                public ItemStack hahaOopsLeakyAbstraction() {
                    return prism.m_8020_(0);
                }
            };
        }
        return null;
    }

    private static int magicNumberToFrameRotation(int magicNumber) {
        if (magicNumber >= 64) {
            return 7;
        }
        if (magicNumber >= 48) {
            return 6;
        }
        if (magicNumber >= 32) {
            return 5;
        }
        if (magicNumber >= 16) {
            return 4;
        }
        if (magicNumber >= 8) {
            return 3;
        }
        if (magicNumber >= 4) {
            return 2;
        }
        if (magicNumber >= 2) {
            return 1;
        }
        return 0;
    }

    private static int frameRotationToMagicNumber(int frameRotation) {
        return switch (frameRotation % 8) {
            case 0 -> 1;
            case 1 -> 2;
            case 2 -> 4;
            case 3 -> 8;
            case 4 -> 16;
            case 5 -> 32;
            case 6 -> 48;
            case 7 -> 64;
            default -> throw new IllegalArgumentException();
        };
    }

    private record FrameCaps(ItemFrame frame) implements DatumAcceptor,
    DatumProvider,
    PositionTweakable
    {
        @Override
        public void acceptDatum(@NotNull Datum<?> datum) {
            if (datum.type() == DataTypes.INTEGER) {
                int oldRotation = this.frame.m_31823_();
                int rotation = NotCapabilities.magicNumberToFrameRotation((Integer)datum.castAndGet());
                this.frame.m_31770_(rotation);
                if (oldRotation != rotation) {
                    this.frame.m_5496_(this.frame.m_142545_(), 1.0f, 1.0f);
                }
            }
        }

        @Override
        @NotNull
        public Datum<?> readDatum(boolean doIt) {
            return DataTypes.SOLIDIFIED_REQUEST.datumOf(SolidifiedRequest.create(this.frame.m_31822_(), NotCapabilities.frameRotationToMagicNumber(this.frame.m_31823_())));
        }

        @Override
        public Vec3 tweakPosition(Level level, BlockPos pos) {
            return this.frame.m_142469_().m_82399_();
        }
    }
}

