/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.computer.types;

import agency.highlysuspect.incorporeal.Inc;
import agency.highlysuspect.incorporeal.computer.types.DataLens;
import agency.highlysuspect.incorporeal.computer.types.DataTypes;
import agency.highlysuspect.incorporeal.computer.types.Datum;
import agency.highlysuspect.incorporeal.corporea.InvertedCorporeaRequestMatcher;
import agency.highlysuspect.incorporeal.corporea.SolidifiedRequest;
import agency.highlysuspect.incorporeal.util.SimplerRegistry;

public class DataLenses {
    public static final SimplerRegistry<DataLens> REGISTRY = new SimplerRegistry();
    public static final DataLens passthrough = input -> input;
    public static final DataLens number = input -> {
        if (input.type() == DataTypes.INTEGER) {
            return input;
        }
        if (input.type() == DataTypes.SOLIDIFIED_REQUEST) {
            return input.cast().mapTo(DataTypes.INTEGER, SolidifiedRequest::count);
        }
        return Datum.EMPTY;
    };
    public static final DataLens matcher = input -> {
        if (input.type() == DataTypes.MATCHER) {
            return input;
        }
        if (input.type() == DataTypes.SOLIDIFIED_REQUEST) {
            return input.cast().mapTo(DataTypes.MATCHER, SolidifiedRequest::matcher);
        }
        return Datum.EMPTY;
    };
    public static final DataLens negating = input -> {
        if (input.type() == DataTypes.INTEGER) {
            return input.cast().map(i -> -i.intValue());
        }
        if (input.type() == DataTypes.MATCHER) {
            return input.cast().map(InvertedCorporeaRequestMatcher::invert);
        }
        if (input.type() == DataTypes.SOLIDIFIED_REQUEST) {
            SolidifiedRequest request = (SolidifiedRequest)input.cast().thing();
            return DataTypes.SOLIDIFIED_REQUEST.datumOf(SolidifiedRequest.create(InvertedCorporeaRequestMatcher.invert(request.matcher()), -request.count()));
        }
        return Datum.EMPTY;
    };

    public static void registerBuiltinLenses() {
        REGISTRY.register(passthrough, Inc.id("passthrough"));
        REGISTRY.register(number, Inc.id("number"));
        REGISTRY.register(matcher, Inc.id("matcher"));
        REGISTRY.register(negating, Inc.id("negating"));
    }
}

