/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.computer.types;

import agency.highlysuspect.incorporeal.computer.types.DataType;
import agency.highlysuspect.incorporeal.computer.types.Datum;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;

public interface DataReducer {
    public Optional<Datum<?>> tryReduce(List<Datum<?>> var1);

    public static <T> Optional<Datum<?>> reduceSingleType(DataType<T> type, List<Datum<?>> data, BiFunction<T, T, T> reducer) {
        if (data.isEmpty()) {
            return Optional.empty();
        }
        for (Datum<?> datum : data) {
            if (datum.type() == type) continue;
            return Optional.empty();
        }
        Object result = null;
        for (Datum<?> datum : data) {
            if (result == null) {
                result = datum.castAndGet();
                continue;
            }
            result = reducer.apply(result, datum.castAndGet());
        }
        return Optional.of(type.datumOf(result));
    }

    public static <T> DataReducer reduceSingleType(DataType<T> type, BiFunction<T, T, T> reducer) {
        return filteredData -> DataReducer.reduceSingleType(type, filteredData, reducer);
    }
}

