/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.computer.types;

import agency.highlysuspect.incorporeal.computer.types.Datum;
import agency.highlysuspect.incorporeal.item.TicketConjurerItem;
import agency.highlysuspect.incorporeal.item.TicketItem;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public interface DataType<T> {
    public void save(T var1, CompoundTag var2);

    default public T infallibleLoad(CompoundTag tag) {
        return this.tryLoad(tag).get();
    }

    default public Optional<T> tryLoad(CompoundTag tag) {
        return Optional.of(this.infallibleLoad(tag));
    }

    public T defaultValue();

    public TicketItem<T> ticketItem();

    default public ItemStack produceTicket(T thing) {
        return this.ticketItem().produce(thing);
    }

    public TicketConjurerItem<T> conjurerItem();

    public int color(@Nullable T var1);

    default public int color() {
        return this.color(null);
    }

    public int signal(T var1);

    public Component describe(T var1);

    public T parse(String var1, ItemStack var2);

    default public Datum<T> parseToDatum(String message, ItemStack otherHand) {
        return this.datumOf(this.parse(message, otherHand));
    }

    default public boolean equals(T a, T b) {
        return Objects.equals(a, b);
    }

    default public int hashCode(T thing) {
        return thing.hashCode();
    }

    default public Datum<T> datumOf(T thing) {
        return new Datum<T>(this, thing);
    }
}

