/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.computer.types;

import agency.highlysuspect.incorporeal.computer.types.DataType;
import agency.highlysuspect.incorporeal.computer.types.DataTypes;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public record Datum<T>(DataType<T> type, T thing) {
    public static final Datum<Unit> EMPTY = new Datum<Unit>(DataTypes.EMPTY, Unit.INSTANCE);

    public int color() {
        return this.type.color(this.thing);
    }

    public boolean isEmpty() {
        return this.type == DataTypes.EMPTY;
    }

    public ItemStack produceTicket() {
        return this.type.produceTicket(this.thing);
    }

    public int signal() {
        return this.type.signal(this.thing);
    }

    public Component describe() {
        return this.type.describe(this.thing);
    }

    public Datum<T> map(UnaryOperator<T> mapper) {
        return new Datum<T>(this.type, mapper.apply(this.thing));
    }

    public <X> Datum<X> mapTo(DataType<X> newType, Function<T, X> mapper) {
        return new Datum<X>(newType, mapper.apply(this.thing));
    }

    public <X> Datum<X> cast() {
        return this;
    }

    public <X> X castAndGet() {
        return (X)this.thing;
    }

    public CompoundTag save() {
        ResourceLocation id = DataTypes.REGISTRY.getKey(this.type);
        CompoundTag tag = new CompoundTag();
        this.type.save(this.thing, tag);
        if (tag.m_128441_("type")) {
            throw new IllegalStateException("Don't add a key named 'type' to DataType<" + this.thing.getClass().getSimpleName() + ">, please");
        }
        tag.m_128359_("type", id.toString());
        return tag;
    }

    public CompoundTag saveWithoutTypeInformation() {
        CompoundTag tag = new CompoundTag();
        this.type.save(this.thing, tag);
        return tag;
    }

    public static Datum<?> load(CompoundTag tag) {
        return Datum.load0(tag);
    }

    private static <T> Datum<T> load0(CompoundTag tag) {
        ResourceLocation id = ResourceLocation.m_135820_((String)tag.m_128461_("type"));
        DataType<?> type = DataTypes.REGISTRY.get(id);
        if (type == null) {
            return EMPTY.cast();
        }
        Optional<?> thing = type.tryLoad(tag);
        if (thing.isEmpty()) {
            return EMPTY.cast();
        }
        return new Datum(type, thing.get());
    }

    public static <T> Datum<T> loadAsType(DataType<T> type, CompoundTag tag) {
        return new Datum<Object>(type, type.tryLoad(tag).orElseGet(type::defaultValue));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Datum other = (Datum)o;
        if (!this.type.equals(other.type)) {
            return false;
        }
        return this.type.equals(this.thing, other.thing);
    }

    @Override
    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.type.hashCode(this.thing);
        return result;
    }
}

