/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.corporea;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class FrameReader {
    public static final BiPredicate<ItemFrame, Direction> NON_EMPTY = (frame, dir) -> !frame.m_31822_().m_41619_();
    public static final BiPredicate<ItemFrame, Direction> RESTING_ON = (frame, dir) -> frame.m_6350_() == dir;

    public static List<ItemStack> itemsNear(Level level, BlockPos pos) {
        return FrameReader.itemsAround(level, pos, null);
    }

    public static List<ItemStack> nonEmptyItemsNear(Level level, BlockPos pos) {
        return FrameReader.itemsAround(level, pos, NON_EMPTY);
    }

    public static List<ItemStack> itemsRestingOn(Level level, BlockPos pos) {
        return FrameReader.itemsAround(level, pos, RESTING_ON);
    }

    public static List<ItemStack> nonEmptyItemsRestingOn(Level level, BlockPos pos) {
        return FrameReader.itemsAround(level, pos, NON_EMPTY.and(RESTING_ON));
    }

    public static List<ItemFrame> near(Level level, BlockPos pos) {
        return FrameReader.framesAround(level, pos, null);
    }

    public static List<ItemFrame> nonEmptyNear(Level level, BlockPos pos) {
        return FrameReader.framesAround(level, pos, NON_EMPTY);
    }

    public static List<ItemFrame> restingOn(Level level, BlockPos pos) {
        return FrameReader.framesAround(level, pos, RESTING_ON);
    }

    public static List<ItemFrame> nonEmptyRestingOn(Level level, BlockPos pos) {
        return FrameReader.framesAround(level, pos, NON_EMPTY.and(RESTING_ON));
    }

    public static Map<Direction, ItemFrame> directionalRestingOn(Level level, BlockPos pos) {
        return FrameReader.directionalFramesRestingOnAround(level, pos, null);
    }

    public static Map<Direction, ItemFrame> directionalNonEmptyRestingOn(Level level, BlockPos pos) {
        return FrameReader.directionalFramesRestingOnAround(level, pos, NON_EMPTY);
    }

    public static List<ItemStack> itemsAround(Level level, BlockPos pos, @Nullable BiPredicate<ItemFrame, Direction> test) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(6);
        for (Direction dir : Direction.values()) {
            BlockPos off = pos.m_142300_(dir);
            for (ItemFrame frame : level.m_45976_(ItemFrame.class, new AABB(off))) {
                if (!frame.m_6084_() || test != null && !test.test(frame, dir)) continue;
                items.add(frame.m_31822_());
            }
        }
        return items;
    }

    public static List<ItemFrame> framesAround(Level level, BlockPos pos, @Nullable BiPredicate<ItemFrame, Direction> test) {
        ArrayList<ItemFrame> frames = new ArrayList<ItemFrame>(6);
        for (Direction dir : Direction.values()) {
            BlockPos off = pos.m_142300_(dir);
            for (ItemFrame frame : level.m_45976_(ItemFrame.class, new AABB(off))) {
                if (!frame.m_6084_() || test != null && !test.test(frame, dir)) continue;
                frames.add(frame);
            }
        }
        return frames;
    }

    public static Map<Direction, ItemFrame> directionalFramesRestingOnAround(Level level, BlockPos pos, @Nullable BiPredicate<ItemFrame, Direction> test) {
        EnumMap<Direction, ItemFrame> frames = new EnumMap<Direction, ItemFrame>(Direction.class);
        for (Direction dir : Direction.values()) {
            BlockPos off = pos.m_142300_(dir);
            for (ItemFrame frame : level.m_45976_(ItemFrame.class, new AABB(off))) {
                if (!frame.m_6084_() || frame.m_6350_() != dir || test != null && !test.test(frame, dir)) continue;
                frames.put(dir, frame);
            }
        }
        return frames;
    }
}

