/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.corporea;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vazkii.botania.api.corporea.ICorporeaRequest;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.impl.corporea.AbstractCorporeaNode;

public abstract class LyingCorporeaNode
extends AbstractCorporeaNode {
    protected final List<ItemStack> spoofStacks;

    public LyingCorporeaNode(Level world, BlockPos pos, ICorporeaSpark spark, List<ItemStack> spoofStacks) {
        super(world, pos, spark);
        this.spoofStacks = spoofStacks;
    }

    protected abstract int countItemsInInventory();

    protected abstract List<ItemStack> extractEverything(ICorporeaRequest var1);

    public List<ItemStack> countItems(ICorporeaRequest request) {
        ICorporeaRequestMatcher matcher = request.getMatcher();
        List matchingSpoofStacks = this.spoofStacks.stream().filter(matcher).collect(Collectors.toList());
        if (matchingSpoofStacks.isEmpty()) {
            return Collections.emptyList();
        }
        int howMany = this.countItemsInInventory();
        if (howMany == 0) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack spoof : matchingSpoofStacks) {
            request.trackFound(howMany);
            request.trackSatisfied(howMany);
            ItemStack copy = spoof.m_41777_();
            copy.m_41764_(howMany);
            result.add(copy);
        }
        return result;
    }

    public List<ItemStack> extractItems(ICorporeaRequest request) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack spoof : this.spoofStacks) {
            if (!request.getMatcher().test(spoof)) continue;
            result.addAll(this.extractEverything(request));
        }
        return result;
    }
}

