/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.corporea;

import agency.highlysuspect.incorporeal.corporea.SolidifiedRequest;
import agency.highlysuspect.incorporeal.mixin.TileCorporeaIndexAccessor;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;

public class RequestParser {
    private static Map<Pattern, TileCorporeaIndex.IRegexStacker> patterns() {
        return TileCorporeaIndexAccessor.inc$getPatterns();
    }

    public static ICorporeaRequestMatcher parseMatcher(String message, ItemStack thisOrderStack) {
        return RequestParser.parseRequest("1 " + message, thisOrderStack).matcher();
    }

    public static int parseCount(String message, ItemStack thisOrderStack) {
        return RequestParser.parseRequest(message + " stone", thisOrderStack).count();
    }

    public static SolidifiedRequest parseRequest(String message, ItemStack thisOrderStack) {
        String msg = message.toLowerCase(Locale.ROOT).trim();
        String name = "";
        int count = 0;
        for (Pattern pattern : RequestParser.patterns().keySet()) {
            Matcher matcher = pattern.matcher(msg);
            if (!matcher.matches()) continue;
            TileCorporeaIndex.IRegexStacker stacker = RequestParser.patterns().get(pattern);
            count = stacker.getCount(matcher);
            name = stacker.getName(matcher).toLowerCase(Locale.ROOT).trim();
        }
        ICorporeaRequestMatcher requestMatcher = name.equals("this") ? CorporeaHelper.instance().createMatcher(thisOrderStack, false) : CorporeaHelper.instance().createMatcher(name);
        return SolidifiedRequest.create(requestMatcher, count);
    }
}

