/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.corporea;

import agency.highlysuspect.incorporeal.corporea.EmptyCorporeaRequestMatcher;
import agency.highlysuspect.incorporeal.corporea.MatcherUtils;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;

public final class SolidifiedRequest {
    public static final SolidifiedRequest EMPTY = new SolidifiedRequest(EmptyCorporeaRequestMatcher.INSTANCE, 0);
    @NotNull
    private final ICorporeaRequestMatcher matcher;
    private final int count;

    private SolidifiedRequest(@NotNull ICorporeaRequestMatcher matcher, int count) {
        this.matcher = matcher;
        this.count = count;
    }

    public static SolidifiedRequest create(@Nullable ICorporeaRequestMatcher matcher, int count) {
        EmptyCorporeaRequestMatcher matcher2 = matcher == null || matcher == ICorporeaRequestMatcher.Dummy.INSTANCE ? EmptyCorporeaRequestMatcher.INSTANCE : matcher;
        return new SolidifiedRequest(matcher2, count);
    }

    public static SolidifiedRequest create(ItemStack stack, int count) {
        EmptyCorporeaRequestMatcher matcher = stack.m_41619_() ? EmptyCorporeaRequestMatcher.INSTANCE : CorporeaHelper.instance().createMatcher(stack, true);
        return new SolidifiedRequest(matcher, count);
    }

    public CompoundTag save() {
        CompoundTag tag = MatcherUtils.save(this.matcher);
        tag.m_128405_("count", this.count);
        return tag;
    }

    public static Optional<SolidifiedRequest> tryLoad(CompoundTag tag) {
        return MatcherUtils.tryLoad(tag).map(matcher -> {
            int count = tag.m_128451_("count");
            return SolidifiedRequest.create(matcher, count);
        });
    }

    public static SolidifiedRequest loadOrEmpty(CompoundTag tag) {
        return SolidifiedRequest.tryLoad(tag).orElse(EMPTY);
    }

    public boolean isEmpty() {
        return this.matcher == EmptyCorporeaRequestMatcher.INSTANCE && this.count == 0;
    }

    public Component toComponent() {
        return new TranslatableComponent("incorporeal.solidified_request", new Object[]{this.count, this.matcher.getRequestName()});
    }

    public int signalStrength() {
        return CorporeaHelper.instance().signalStrengthForRequestSize(this.count);
    }

    public SolidifiedRequest withCount(int newCount) {
        return new SolidifiedRequest(this.matcher, newCount);
    }

    @NotNull
    public ICorporeaRequestMatcher matcher() {
        return this.matcher;
    }

    public int count() {
        return this.count;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SolidifiedRequest that = (SolidifiedRequest)obj;
        return Objects.equals(this.matcher, that.matcher) && this.count == that.count;
    }

    public int hashCode() {
        return Objects.hash(this.matcher, this.count);
    }

    public String toString() {
        return "SolidifiedRequest[matcher=" + this.matcher + ", count=" + this.count + "]";
    }
}

