/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.datagen;

import agency.highlysuspect.incorporeal.Inc;
import agency.highlysuspect.incorporeal.datagen.JsonFile;
import agency.highlysuspect.incorporeal.datagen.NiceTagBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class DataDsl {
    private static final ResourceLocation AIR = new ResourceLocation("minecraft", "air");

    public static ResourceLocation notAir(ResourceLocation in) {
        if (in.equals((Object)AIR)) {
            throw new IllegalArgumentException("minecraft:air");
        }
        return in;
    }

    public static ResourceLocation mapPath(ResourceLocation in, UnaryOperator<String> mapper) {
        return new ResourceLocation(in.m_135827_(), (String)mapper.apply(in.m_135815_()));
    }

    public static ResourceLocation prefixPath(ResourceLocation in, String pathPrefix) {
        return new ResourceLocation(in.m_135827_(), pathPrefix + "/" + in.m_135815_());
    }

    public static void addProvider(final DataGenerator datagen, final String name, final BiConsumer<DataGenerator, Consumer<JsonFile>> generator) {
        datagen.m_123914_(new DataProvider(){

            public void m_6865_(HashCache hashCache) throws IOException {
                ArrayList bucket = new ArrayList();
                generator.accept(datagen, bucket::add);
                bucket.forEach(f -> {
                    Inc.LOGGER.info("Saving " + String.join((CharSequence)"/", f.pathSegments()));
                    f.save(datagen, hashCache);
                });
            }

            public String m_6055_() {
                return name;
            }
        });
    }

    public static NiceTagBuilder blockTag(ResourceLocation tagRl) {
        return new NiceTagBuilder("blocks", tagRl);
    }

    public static NiceTagBuilder blockTag(TagKey<Block> tag) {
        return DataDsl.blockTag(tag.f_203868_());
    }

    public static NiceTagBuilder itemTag(ResourceLocation tagRl) {
        return new NiceTagBuilder("items", tagRl);
    }

    public static NiceTagBuilder itemTag(TagKey<Item> tag) {
        return DataDsl.itemTag(tag.f_203868_());
    }

    public static NiceTagBuilder.Duplex blockAndItemTag(ResourceLocation tagRl) {
        return new NiceTagBuilder.Duplex(tagRl);
    }

    public static NiceTagBuilder.Duplex blockAndItemTag(TagKey<Block> tag) {
        return DataDsl.blockAndItemTag(tag.f_203868_());
    }

    public static void saveBlockLootTable(Consumer<JsonFile> fileConsumer, Block block, LootTable.Builder table) {
        ResourceLocation rl = DataDsl.notAir(Registry.f_122824_.m_7981_((Object)block));
        fileConsumer.accept(JsonFile.create(DataDsl.serializeBlockLootTable(table), "data", rl.m_135827_(), "loot_tables/blocks", rl.m_135815_()));
    }

    public static JsonElement serializeBlockLootTable(LootTable.Builder builder) {
        return LootTables.m_79200_((LootTable)builder.m_79165_(LootContextParamSets.f_81421_).m_79167_());
    }

    public static LootTable.Builder selfDrop(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)b);
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_6509_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(pool);
    }
}

