/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.datagen;

import agency.highlysuspect.incorporeal.Inc;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class EnUsRewriter {
    private static final String DELIMITER = "en-us-rewriter.marker";
    private final Map<String, String> entries = new LinkedHashMap<String, String>();

    public void associate(String key, String value) {
        this.entries.put(key, value);
    }

    public void rewrite() {
        if (this.entries.isEmpty()) {
            return;
        }
        Inc.LOGGER.info("Rewriting en_us.json (appending {} entries)", (Object)this.entries.size());
        String systemProperty = System.getProperty("incorporeal.en-us");
        if (systemProperty == null || systemProperty.isEmpty()) {
            Inc.LOGGER.warn("Cannot rewrite en_us.json - Did not set incorporeal.en-us system property");
            return;
        }
        Path enUsPath = Paths.get(systemProperty, new String[0]);
        try {
            String enUs = Files.readString(enUsPath, StandardCharsets.UTF_8);
            int delimiterIndex = enUs.indexOf(DELIMITER);
            int newlineAfterDelim = enUs.indexOf(10, delimiterIndex);
            String truncated = enUs.substring(0, newlineAfterDelim + 1);
            String rewritten = truncated + this.entries.entrySet().stream().map(entry -> "\t\"" + EnUsRewriter.escape((String)entry.getKey()) + "\": \"" + EnUsRewriter.escape((String)entry.getValue()) + "\"").collect(Collectors.joining(",\n")) + "\n}\n";
            Files.writeString(enUsPath, (CharSequence)rewritten, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String escape(String in) {
        return in.replace("\"", "\\\"");
    }
}

