/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.datagen;

import agency.highlysuspect.incorporeal.Inc;
import agency.highlysuspect.incorporeal.IncBlocks;
import agency.highlysuspect.incorporeal.IncItems;
import agency.highlysuspect.incorporeal.block.CompressedTinyPotatoBlock;
import agency.highlysuspect.incorporeal.block.CorporeaPylonBlock;
import agency.highlysuspect.incorporeal.block.CrappyComparatorBlock;
import agency.highlysuspect.incorporeal.block.PointedDatastoneBlock;
import agency.highlysuspect.incorporeal.block.RedstoneRootCropBlock;
import agency.highlysuspect.incorporeal.datagen.DataDsl;
import agency.highlysuspect.incorporeal.datagen.ItemTransformUtil;
import agency.highlysuspect.incorporeal.datagen.JsonFile;
import agency.highlysuspect.incorporeal.mixin.datagen.IncAccessorBlockModelGenerators;
import agency.highlysuspect.incorporeal.mixin.datagen.TextureSlotAccessor;
import agency.highlysuspect.incorporeal.util.CompressedTaterUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.mixin.AccessorBlockModelGenerators;

public class IncCommonModelsAndBlockstates {
    private static final List<BlockStateGenerator> stateGenerators = new ArrayList<BlockStateGenerator>();
    private static final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();
    private static final BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = models::put;
    public static final ModelTemplate threeHighBottomTopTemplate = IncCommonModelsAndBlockstates.template(Inc.botaniaId("block/shapes/three_high_bottom_top"), TextureSlot.f_125871_, TextureSlot.f_125872_, TextureSlot.f_125875_);
    public static final ModelTemplate crossTemplate = IncCommonModelsAndBlockstates.template(Inc.botaniaId("block/shapes/cross"), TextureSlot.f_125882_);
    public static final TextureSlot TX_TORCH = IncCommonModelsAndBlockstates.txslot("torch");
    public static final ModelTemplate naturalRepeater = IncCommonModelsAndBlockstates.template(Inc.id("block/natural_devices/natural_repeater"), TextureSlot.f_125872_, TX_TORCH);
    public static final TextureSlot TX_TORCH_FRONT = IncCommonModelsAndBlockstates.txslot("torch_front");
    public static final TextureSlot TX_TORCH_BACK = IncCommonModelsAndBlockstates.txslot("torch_back");
    public static final ModelTemplate naturalComparator = IncCommonModelsAndBlockstates.template(Inc.id("block/natural_devices/natural_comparator"), TextureSlot.f_125872_, TX_TORCH_FRONT, TX_TORCH_BACK);
    public static final ModelTemplate pointedDripstone = IncCommonModelsAndBlockstates.template(new ResourceLocation("block/pointed_dripstone"), TextureSlot.f_125882_);
    public static final TextureSlot TX_LAYER1 = IncCommonModelsAndBlockstates.txslot("layer1");
    private static final ModelTemplate GENERATED_1 = IncCommonModelsAndBlockstates.template(new ResourceLocation("item/generated"), TextureSlot.f_125863_, TX_LAYER1);

    public static void doIt(DataGenerator generator, Consumer<JsonFile> files) {
        IncCommonModelsAndBlockstates.itemGenerated((ItemLike)IncItems.FRACTURED_SPACE_ROD, Inc.id("item/fractured_space_rod/tex"));
        IncCommonModelsAndBlockstates.singleVariantCubeColumn(IncBlocks.CORPOREA_SOLIDIFIER, Inc.id("block/corporea_solidifier/side"), Inc.id("block/corporea_solidifier/top_bottom"));
        IncCommonModelsAndBlockstates.itemBlockModelParent(IncBlocks.CORPOREA_SOLIDIFIER);
        IncCommonModelsAndBlockstates.redString((Block)IncBlocks.RED_STRING_LIAR, Inc.id("block/red_string_liar/side"));
        IncCommonModelsAndBlockstates.itemBlockModelParent((Block)IncBlocks.RED_STRING_LIAR);
        IncCommonModelsAndBlockstates.redString((Block)IncBlocks.RED_STRING_CONSTRICTOR, Inc.id("block/red_string_constrictor/side"));
        IncCommonModelsAndBlockstates.itemBlockModelParent((Block)IncBlocks.RED_STRING_CONSTRICTOR);
        IncCommonModelsAndBlockstates.singleVariantThreeHighBottomTop((Block)IncBlocks.FRAME_TINKERER, Inc.id("block/frame_tinkerer/bottom"), Inc.id("block/frame_tinkerer/top"), Inc.id("block/frame_tinkerer/side"));
        IncCommonModelsAndBlockstates.itemBlockModelParent((Block)IncBlocks.FRAME_TINKERER);
        stateGenerators.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)IncBlocks.CORPOREA_PYLON).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_(CorporeaPylonBlock.WHICH).m_125329_((Comparable)((Object)CorporeaPylonBlock.Which.TOP), IncCommonModelsAndBlockstates.modelv(Inc.id("block/corporea_pylon/top"))).m_125329_((Comparable)((Object)CorporeaPylonBlock.Which.MIDDLE), IncCommonModelsAndBlockstates.modelv(Inc.id("block/corporea_pylon/middle"))).m_125329_((Comparable)((Object)CorporeaPylonBlock.Which.BOTTOM), IncCommonModelsAndBlockstates.modelv(Inc.id("block/corporea_pylon/bottom")))));
        TextureSlot TX_INNER = IncCommonModelsAndBlockstates.txslot("inner");
        TextureSlot TX_OUTER = IncCommonModelsAndBlockstates.txslot("outer");
        ModelTemplate soulCoreTemplate = IncCommonModelsAndBlockstates.template(Inc.id("block/soul_core"), TX_INNER, TX_OUTER);
        IncCommonModelsAndBlockstates.singleVariantBlockState((Block)IncBlocks.ENDER_SOUL_CORE, soulCoreTemplate.m_125592_((Block)IncBlocks.ENDER_SOUL_CORE, IncCommonModelsAndBlockstates.txmap(TX_INNER, Inc.id("block/soul_cores/ender_inner"), TX_OUTER, Inc.id("block/soul_cores/ender_outer")), modelOutput));
        IncCommonModelsAndBlockstates.itemBlockRotationsBuiltinEntity((ItemLike)IncBlocks.ENDER_SOUL_CORE);
        IncCommonModelsAndBlockstates.singleVariantBlockState((Block)IncBlocks.POTION_SOUL_CORE, soulCoreTemplate.m_125592_((Block)IncBlocks.POTION_SOUL_CORE, IncCommonModelsAndBlockstates.txmap(TX_INNER, Inc.id("block/soul_cores/potion_inner"), TX_OUTER, Inc.id("block/soul_cores/potion_outer")), modelOutput));
        IncCommonModelsAndBlockstates.itemBlockRotationsBuiltinEntity((ItemLike)IncBlocks.POTION_SOUL_CORE);
        soulCoreTemplate.m_125612_(Inc.id("block/soul_core_frame"), IncCommonModelsAndBlockstates.txmap(TX_INNER, Inc.id("block/soul_cores/frame_inner"), TX_OUTER, Inc.id("block/soul_cores/frame_outer")), modelOutput);
        IncCommonModelsAndBlockstates.itemBlockRotationsBuiltinEntity((ItemLike)IncItems.SOUL_CORE_FRAME);
        TextureSlot TX_HAT = IncCommonModelsAndBlockstates.txslot("hat");
        ModelTemplate shortCrossWithHat = IncCommonModelsAndBlockstates.template(Inc.id("block/natural_devices/short_cross_with_hat"), TextureSlot.f_125882_, TX_HAT);
        stateGenerators.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)IncBlocks.REDSTONE_ROOT_CROP).m_125271_(PropertyDispatch.m_125294_((Property)RedstoneRootCropBlock.AGE).m_125335_(age -> IncCommonModelsAndBlockstates.modelv(shortCrossWithHat.m_125612_(Inc.id("block/natural_devices/crop_" + age), IncCommonModelsAndBlockstates.txmap(TextureSlot.f_125882_, Inc.id("block/natural_devices/cross/" + (age >= 4 ? "large" : "small")), TX_HAT, Inc.id("block/natural_devices/top/growing_" + age)), modelOutput)))));
        stateGenerators.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)IncBlocks.NATURAL_REPEATER).m_125271_(IncAccessorBlockModelGenerators.horizontalDispatchAlt()).m_125271_(PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61448_).m_125335_(powered -> IncCommonModelsAndBlockstates.modelv(IncCommonModelsAndBlockstates.naturalRepeaterModel(powered)))));
        IncCommonModelsAndBlockstates.itemDelegatedTo((ItemLike)IncBlocks.NATURAL_REPEATER, IncCommonModelsAndBlockstates.naturalRepeaterModel(false));
        stateGenerators.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)IncBlocks.NATURAL_COMPARATOR).m_125271_(IncAccessorBlockModelGenerators.horizontalDispatchAlt()).m_125271_(PropertyDispatch.m_125296_((Property)BlockStateProperties.f_61448_, (Property)CrappyComparatorBlock.SENSITIVE).m_125362_((powered, sensitive) -> IncCommonModelsAndBlockstates.modelv(IncCommonModelsAndBlockstates.naturalComparatorModel(powered, sensitive)))));
        IncCommonModelsAndBlockstates.itemDelegatedTo((ItemLike)IncBlocks.NATURAL_COMPARATOR, IncCommonModelsAndBlockstates.naturalComparatorModel(false, false));
        IncCommonModelsAndBlockstates.flowerWithItemModel((Block)IncBlocks.SANVOCALIA, Inc.id("block/sanvocalia/big"));
        IncCommonModelsAndBlockstates.flowerWithItemModel((Block)IncBlocks.SANVOCALIA_SMALL, Inc.id("block/sanvocalia/small"));
        IncCommonModelsAndBlockstates.flowerWithItemModel((Block)IncBlocks.FUNNY, Inc.id("block/funny/thisissosad"));
        IncCommonModelsAndBlockstates.flowerWithItemModel((Block)IncBlocks.FUNNY_SMALL, Inc.id("block/funny/alexaplaydespacito"));
        IncCommonModelsAndBlockstates.floatingFlowerWithItemModel((Block)IncBlocks.FLOATING_SANVOCALIA, (Block)IncBlocks.SANVOCALIA);
        IncCommonModelsAndBlockstates.floatingFlowerWithItemModel((Block)IncBlocks.FLOATING_SANVOCALIA_SMALL, (Block)IncBlocks.SANVOCALIA_SMALL);
        IncCommonModelsAndBlockstates.floatingFlowerWithItemModel((Block)IncBlocks.FLOATING_FUNNY, (Block)IncBlocks.FUNNY);
        IncCommonModelsAndBlockstates.floatingFlowerWithItemModel((Block)IncBlocks.FLOATING_FUNNY_SMALL, (Block)IncBlocks.FUNNY_SMALL);
        for (Block block : IncBlocks.UNSTABLE_CUBES.values()) {
            IncCommonModelsAndBlockstates.singleVariantBlockState(block, Inc.id("block/unstable_cube"));
            IncCommonModelsAndBlockstates.itemBlockRotationsBuiltinEntity((ItemLike)block);
        }
        IncCommonModelsAndBlockstates.singleVariantCubeColumn(IncBlocks.CLEARLY, Inc.id("block/clearly"), Inc.id("black"));
        IncCommonModelsAndBlockstates.itemBlockModelParent(IncBlocks.CLEARLY);
        ModelTemplate carpetTintindex = IncCommonModelsAndBlockstates.template(Inc.id("block/carpet_tintindex"), TextureSlot.f_125886_);
        ResourceLocation resourceLocation = carpetTintindex.m_125612_(Inc.id("block/petal_block_carpet"), IncCommonModelsAndBlockstates.txmap(TextureSlot.f_125886_, Inc.botaniaId("block/petal_block")), modelOutput);
        IncBlocks.PETAL_CARPETS.forEach((color, carpet) -> {
            IncCommonModelsAndBlockstates.singleVariantBlockState((Block)carpet, petalCarpetModel);
            IncCommonModelsAndBlockstates.itemDelegatedTo((ItemLike)carpet, petalCarpetModel);
        });
        for (CompressedTinyPotatoBlock tater : IncBlocks.COMPRESSED_TATERS.values()) {
            ResourceLocation modelId = ModelLocationUtils.m_125576_((Block)tater);
            JsonObject json = new JsonObject();
            json.addProperty("parent", ModelLocationUtils.m_125576_((Block)ModBlocks.tinyPotato).toString());
            ItemTransforms transforms = ItemTransformUtil.scaleItemTransforms(ItemTransformUtil.BLOCK_BLOCK, CompressedTaterUtil.taterScaleFactor(tater.compressionLevel));
            json.add("display", (JsonElement)ItemTransformUtil.toJson(transforms));
            modelOutput.accept(modelId, () -> json);
            stateGenerators.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)tater, (Variant)IncCommonModelsAndBlockstates.modelv(modelId)).m_125271_(AccessorBlockModelGenerators.horizontalDispatch()));
            IncCommonModelsAndBlockstates.itemDelegatedTo((ItemLike)tater, modelId);
        }
        IncCommonModelsAndBlockstates.itemGenerated((ItemLike)IncItems.ENTERBRILLIANCE, Inc.id("item/computer/enterbrilliance"));
        IncCommonModelsAndBlockstates.itemGenerated((ItemLike)IncItems.DATA_MONOCLE, Inc.id("item/computer/monocle"));
        IncCommonModelsAndBlockstates.itemGenerated(IncItems.EMPTY_CONJURER, Inc.id("item/computer/ticket/empty_conjurer"));
        IncCommonModelsAndBlockstates.itemGenerated(IncItems.INTEGER_CONJURER, Inc.id("item/computer/ticket/integer_conjurer"));
        IncCommonModelsAndBlockstates.itemGenerated(IncItems.MATCHER_CONJURER, Inc.id("item/computer/ticket/matcher_conjurer"));
        IncCommonModelsAndBlockstates.itemGenerated(IncItems.SOLIDIFIED_REQUEST_CONJURER, Inc.id("item/computer/ticket/solidified_request_conjurer"));
        IncCommonModelsAndBlockstates.singleVariantBlockState(IncBlocks.DATA_FUNNEL, Inc.id("block/computer/data_funnel"));
        IncCommonModelsAndBlockstates.itemDelegatedTo((ItemLike)IncBlocks.DATA_FUNNEL, Inc.id("block/computer/data_funnel"));
        ResourceLocation lensGlassDark = Inc.id("item/computer/lens_glass_dark");
        ResourceLocation lensGlassDarkSmall = Inc.id("item/computer/lens_glass_dark_small");
        IncCommonModelsAndBlockstates.itemLens((ItemLike)IncItems.NUMBER_LENS, lensGlassDark, Inc.id("item/computer/number_lens"));
        IncCommonModelsAndBlockstates.itemLens((ItemLike)IncItems.MATCHER_LENS, lensGlassDark, Inc.id("item/computer/matcher_lens"));
        IncCommonModelsAndBlockstates.itemLens((ItemLike)IncItems.NEGATING_LENS, lensGlassDarkSmall, Inc.id("item/computer/negating_lens"));
        IncCommonModelsAndBlockstates.itemLens((ItemLike)IncItems.COMPUTATIONAL_LENS_PATTERN, lensGlassDark, Inc.botaniaId("item/lens_normal"));
        IncCommonModelsAndBlockstates.singleVariantCubeAll((Block)IncBlocks.DATASTONE_BLOCK, Inc.id("block/computer/datastone"));
        IncCommonModelsAndBlockstates.itemBlockModelParent((Block)IncBlocks.DATASTONE_BLOCK);
        stateGenerators.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)IncBlocks.POINTED_DATASTONE).m_125271_(PropertyDispatch.m_125294_(PointedDatastoneBlock.TYPE).m_125335_(type -> {
            ResourceLocation modelId = Inc.id("block/computer/pointed_datastone/" + type.m_7912_());
            ResourceLocation texture = Inc.id("block/computer/pointed_datastone_" + type.m_7912_());
            return IncCommonModelsAndBlockstates.modelv(IncCommonModelsAndBlockstates.pointedDripstoneModel(modelId, texture));
        })));
        stateGenerators.forEach(stateGenerator -> {
            ResourceLocation id = DataDsl.notAir(Registry.f_122824_.m_7981_((Object)stateGenerator.m_6968_()));
            files.accept(JsonFile.create((JsonElement)stateGenerator.get(), "assets", id.m_135827_(), "blockstates", id.m_135815_()));
        });
        models.forEach((id, elementSupplier) -> files.accept(JsonFile.create((JsonElement)elementSupplier.get(), "assets", id.m_135827_(), "models", id.m_135815_())));
    }

    public static void singleVariantBlockState(Block b, ResourceLocation model) {
        stateGenerators.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)b, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model)));
    }

    public static void singleVariantParticleOnly(Block b, ResourceLocation texture) {
        IncCommonModelsAndBlockstates.singleVariantBlockState(b, ModelTemplates.f_125626_.m_125592_(b, TextureMapping.m_125812_((ResourceLocation)texture), modelOutput));
    }

    public static void singleVariantCubeAll(Block b, ResourceLocation texture) {
        IncCommonModelsAndBlockstates.singleVariantBlockState(b, ModelTemplates.f_125692_.m_125592_(b, TextureMapping.m_125776_((ResourceLocation)texture), modelOutput));
    }

    public static void singleVariantCubeColumn(Block b, ResourceLocation side, ResourceLocation end) {
        IncCommonModelsAndBlockstates.singleVariantBlockState(b, ModelTemplates.f_125694_.m_125592_(b, TextureMapping.m_125763_((ResourceLocation)side, (ResourceLocation)end), modelOutput));
    }

    public static void singleVariantThreeHighBottomTop(Block b, ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        IncCommonModelsAndBlockstates.singleVariantBlockState(b, threeHighBottomTopTemplate.m_125592_(b, IncCommonModelsAndBlockstates.txmap(TextureSlot.f_125871_, bottom, TextureSlot.f_125872_, top).m_125758_(TextureSlot.f_125875_, side), modelOutput));
    }

    public static void flowerWithItemModel(Block b, ResourceLocation texture) {
        IncCommonModelsAndBlockstates.singleVariantBlockState(b, crossTemplate.m_125592_(b, TextureMapping.m_125788_((ResourceLocation)texture), modelOutput));
        IncCommonModelsAndBlockstates.itemGenerated((ItemLike)b, texture);
    }

    public static void floatingFlowerWithItemModel(Block floating, Block nonFloating) {
        ResourceLocation floatingModelId = DataDsl.prefixPath(Registry.f_122824_.m_7981_((Object)floating), "block");
        ResourceLocation nonFloatingModelId = DataDsl.prefixPath(Registry.f_122824_.m_7981_((Object)nonFloating), "block");
        JsonObject json = new JsonObject();
        json.addProperty("parent", "minecraft:block/block");
        json.addProperty("loader", "botania:floating_flower");
        JsonObject flower = new JsonObject();
        flower.addProperty("parent", nonFloatingModelId.toString());
        json.add("flower", (JsonElement)flower);
        modelOutput.accept(floatingModelId, () -> json);
        IncCommonModelsAndBlockstates.singleVariantBlockState(floating, floatingModelId);
        modelOutput.accept(DataDsl.prefixPath(Registry.f_122824_.m_7981_((Object)floating), "item"), () -> json);
    }

    public static void redString(Block block, ResourceLocation texture) {
        ResourceLocation modelId = ModelTemplates.f_125698_.m_125592_(block, IncCommonModelsAndBlockstates.txmap(TextureSlot.f_125872_, texture, TextureSlot.f_125875_, texture, TextureSlot.f_125873_, Inc.botaniaId("block/red_string_sender")), modelOutput);
        stateGenerators.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)block, (Variant)IncCommonModelsAndBlockstates.modelv(modelId)).m_125271_(AccessorBlockModelGenerators.facingDispatch()));
    }

    public static ResourceLocation naturalRepeaterModel(boolean lit) {
        ResourceLocation modelId = Inc.id("block/natural_devices/natural_repeater_" + (lit ? "lit" : "unlit"));
        ResourceLocation topTexture = Inc.id("block/natural_devices/top/repeater_" + (lit ? "lit" : "unlit"));
        return naturalRepeater.m_125612_(modelId, IncCommonModelsAndBlockstates.txmap(TextureSlot.f_125872_, topTexture, TX_TORCH, IncCommonModelsAndBlockstates.naturalDeviceTorchTexture(lit)), modelOutput);
    }

    public static ResourceLocation naturalComparatorModel(boolean lit, boolean sensitive) {
        ResourceLocation modelId = Inc.id("block/natural_devices/natural_comparator_" + (sensitive ? "sensitive_" : "") + (lit ? "lit" : "unlit"));
        ResourceLocation topTexture = Inc.id("block/natural_devices/top/comparator_" + (lit ? "lit" : "unlit"));
        return naturalComparator.m_125612_(modelId, IncCommonModelsAndBlockstates.txmap(TextureSlot.f_125872_, topTexture, TX_TORCH_FRONT, IncCommonModelsAndBlockstates.naturalDeviceTorchTexture(sensitive), TX_TORCH_BACK, IncCommonModelsAndBlockstates.naturalDeviceTorchTexture(lit)), modelOutput);
    }

    public static ResourceLocation naturalDeviceTorchTexture(boolean torchLit) {
        return Inc.id("block/natural_devices/torch_" + (torchLit ? "lit" : "unlit"));
    }

    public static ResourceLocation pointedDripstoneModel(ResourceLocation modelId, ResourceLocation texture) {
        return pointedDripstone.m_125612_(modelId, IncCommonModelsAndBlockstates.txmap(TextureSlot.f_125882_, texture), modelOutput);
    }

    public static void itemBlockModelParent(Block block) {
        IncCommonModelsAndBlockstates.itemBlockModelParent((ItemLike)block, block);
    }

    public static void itemBlockModelParent(ItemLike item, Block blockParent) {
        IncCommonModelsAndBlockstates.itemDelegatedTo(item, ModelLocationUtils.m_125576_((Block)blockParent));
    }

    public static void itemBlockRotationsBuiltinEntity(ItemLike item) {
        IncCommonModelsAndBlockstates.itemDelegatedTo(item, Inc.id("item/block_rotations_builtin_entity"));
    }

    public static void itemDelegatedTo(ItemLike item, ResourceLocation delegated) {
        modelOutput.accept(ModelLocationUtils.m_125571_((Item)item.m_5456_()), (Supplier<JsonElement>)new DelegatedModel(delegated));
    }

    public static void itemGenerated(ItemLike b, ResourceLocation texture) {
        ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)b.m_5456_()), TextureMapping.m_125820_((ResourceLocation)texture), modelOutput);
    }

    public static void itemLens(ItemLike b, ResourceLocation lensGlass, ResourceLocation lensFrame) {
        GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)b.m_5456_()), IncCommonModelsAndBlockstates.txmap(TextureSlot.f_125863_, lensGlass, TX_LAYER1, lensFrame), modelOutput);
    }

    public static Variant modelv(ResourceLocation id) {
        return Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id);
    }

    public static TextureSlot txslot(String name) {
        return TextureSlotAccessor.inc$create(name);
    }

    public static TextureMapping txmap(Object ... inputs) {
        TextureMapping mapping = new TextureMapping();
        Iterator<Object> objerator = List.of(inputs).iterator();
        while (objerator.hasNext()) {
            TextureSlot slot = (TextureSlot)objerator.next();
            ResourceLocation texture = (ResourceLocation)objerator.next();
            mapping = mapping.m_125758_(slot, texture);
        }
        return mapping;
    }

    public static ModelTemplate template(ResourceLocation id, TextureSlot ... slots) {
        return new ModelTemplate(Optional.of(id), Optional.empty(), slots);
    }
}

