/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.datagen;

import agency.highlysuspect.incorporeal.datagen.DataDsl;
import agency.highlysuspect.incorporeal.datagen.JsonFile;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.helper.ItemNBTHelper;

public class ManaInfusionRecipeBuilder {
    private final ItemStack output;
    private final int mana;
    private Ingredient input;
    private String group = "";
    @Nullable
    private StateIngredient catalyst;

    public ManaInfusionRecipeBuilder(ItemStack output, int mana) {
        this.output = output;
        this.mana = mana;
    }

    public static ManaInfusionRecipeBuilder create(ItemStack output, int mana) {
        return new ManaInfusionRecipeBuilder(output, mana);
    }

    public static ManaInfusionRecipeBuilder create(ItemLike output, int mana) {
        return ManaInfusionRecipeBuilder.create(new ItemStack(output), mana);
    }

    public ManaInfusionRecipeBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public ManaInfusionRecipeBuilder input(ItemLike input) {
        return this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}));
    }

    public ManaInfusionRecipeBuilder input(TagKey<Item> input) {
        return this.input(Ingredient.m_204132_(input));
    }

    public ManaInfusionRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public ManaInfusionRecipeBuilder catalyst(StateIngredient catalyst) {
        this.catalyst = catalyst;
        return this;
    }

    public ManaInfusionRecipeBuilder alchemyCatalyst() {
        return this.catalyst(StateIngredientHelper.of((Block)ModBlocks.alchemyCatalyst));
    }

    public ManaInfusionRecipeBuilder conjurationCatalyst() {
        return this.catalyst(StateIngredientHelper.of((Block)ModBlocks.conjurationCatalyst));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "botania:mana_infusion");
        json.add("input", this.input.m_43942_());
        json.add("output", (JsonElement)ItemNBTHelper.serializeStack((ItemStack)this.output));
        json.addProperty("mana", (Number)this.mana);
        if (!this.group.isEmpty()) {
            json.addProperty("group", this.group);
        }
        if (this.catalyst != null) {
            json.add("catalyst", (JsonElement)this.catalyst.serialize());
        }
        return json;
    }

    public void save(Consumer<JsonFile> fileConsumer) {
        this.save(fileConsumer, RecipeBuilder.m_176493_((ItemLike)this.output.m_41720_()));
    }

    public void save(Consumer<JsonFile> fileConsumer, ResourceLocation id) {
        DataDsl.notAir(id);
        fileConsumer.accept(JsonFile.create((JsonElement)this.toJson(), "data", id.m_135827_(), "recipes", "mana_infusion", id.m_135815_()));
    }
}

