/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.datagen;

import agency.highlysuspect.incorporeal.datagen.JsonFile;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class NiceTagBuilder {
    public final String classifier;
    public final ResourceLocation id;
    public boolean replace = false;
    public final List<String> entries = new ArrayList<String>();

    public NiceTagBuilder(String classifier, ResourceLocation id) {
        this.classifier = classifier;
        this.id = id;
    }

    public NiceTagBuilder replace() {
        this.replace = true;
        return this;
    }

    public NiceTagBuilder addBlocks(Collection<? extends Block> blocks) {
        blocks.stream().map(arg_0 -> ((DefaultedRegistry)Registry.f_122824_).m_7981_(arg_0)).map(ResourceLocation::toString).forEach(this.entries::add);
        return this;
    }

    public NiceTagBuilder addBlocks(Block ... blocks) {
        return this.addBlocks(List.of(blocks));
    }

    public NiceTagBuilder addItems(Collection<? extends ItemLike> itemLikes) {
        itemLikes.stream().map(ItemLike::m_5456_).map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_7981_(arg_0)).map(ResourceLocation::toString).forEach(this.entries::add);
        return this;
    }

    public NiceTagBuilder addItems(ItemLike ... itemLikes) {
        return this.addItems(List.of(itemLikes));
    }

    public NiceTagBuilder addTags(TagKey<?> ... tags) {
        Stream.of(tags).map(TagKey::f_203868_).map(ResourceLocation::toString).forEach(str -> this.entries.add("#" + str));
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("replace", Boolean.valueOf(this.replace));
        JsonArray array = new JsonArray();
        this.entries.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        json.add("values", (JsonElement)array);
        return json;
    }

    public void save(Consumer<JsonFile> fileConsumer) {
        fileConsumer.accept(JsonFile.create((JsonElement)this.toJson(), "data", this.id.m_135827_(), "tags", this.classifier, this.id.m_135815_()));
    }

    public static class Duplex {
        public final NiceTagBuilder blocks;
        public final NiceTagBuilder items;

        public Duplex(ResourceLocation id) {
            this.blocks = new NiceTagBuilder("blocks", id);
            this.items = new NiceTagBuilder("items", id);
        }

        public Duplex add(Block ... blockItems) {
            this.blocks.addBlocks(blockItems);
            this.items.addItems((ItemLike[])blockItems);
            return this;
        }

        public Duplex add(Collection<? extends Block> wah) {
            this.blocks.addBlocks(wah);
            this.items.addItems(wah);
            return this;
        }

        public void save(Consumer<JsonFile> fileConsumer) {
            this.blocks.save(fileConsumer);
            this.items.save(fileConsumer);
        }
    }
}

