/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.datagen;

import agency.highlysuspect.incorporeal.datagen.DataDsl;
import agency.highlysuspect.incorporeal.datagen.DatagenDuck;
import agency.highlysuspect.incorporeal.datagen.EnUsRewriter;
import agency.highlysuspect.incorporeal.datagen.JsonFile;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class PatchouliEntryBuilder {
    public final ResourceLocation bookId;
    public final ResourceLocation path;
    public final String langBase;
    public String name = "Unnamed Incorporeal Entry";
    public boolean addLangEntryForName = true;
    public String category = "missing:category";
    public Item icon = Items.f_41905_;
    public boolean readByDefault = false;
    @Nullable
    public String advancement;
    public int color = -1;
    public int sortnum = -1;
    public Map<String, Integer> extraRecipeMappings = new HashMap<String, Integer>();
    public List<Page> pages = new ArrayList<Page>();

    public PatchouliEntryBuilder(ResourceLocation bookId, String shortPath) {
        this.bookId = bookId;
        this.path = new ResourceLocation(bookId.m_135827_(), shortPath);
        this.langBase = Stream.of(bookId.m_135827_(), bookId.m_135815_(), shortPath.replace('/', '.')).collect(Collectors.joining("."));
    }

    public PatchouliEntryBuilder save(DataGenerator datagen, Consumer<JsonFile> files) {
        JsonObject json = new JsonObject();
        EnUsRewriter rewriter = ((DatagenDuck)datagen).inc$getEnUsRewriter();
        if (this.addLangEntryForName) {
            String langKey = this.langKey("name");
            json.addProperty("name", langKey);
            rewriter.associate(langKey, this.name);
        } else {
            json.addProperty("name", this.name);
        }
        json.addProperty("category", this.category);
        json.addProperty("icon", DataDsl.notAir(Registry.f_122827_.m_7981_((Object)this.icon)).toString());
        if (this.readByDefault) {
            json.addProperty("read_by_default", Boolean.valueOf(true));
        }
        if (this.advancement != null) {
            json.addProperty("advancement", this.advancement);
        }
        if (this.color != -1) {
            json.addProperty("entry_color", String.format("%06x", this.color));
        }
        if (this.sortnum != -1) {
            json.addProperty("sortnum", (Number)this.sortnum);
        }
        JsonArray pagesArray = new JsonArray();
        MutableInt currentPage = new MutableInt(0);
        for (Page page : this.pages) {
            pagesArray.add((JsonElement)page.toJson((keySuffix, value) -> {
                String key = this.langKey(currentPage.intValue(), keySuffix);
                rewriter.associate(key, value);
                return key;
            }));
            currentPage.increment();
        }
        json.add("pages", (JsonElement)pagesArray);
        if (!this.extraRecipeMappings.isEmpty()) {
            JsonObject mappings = new JsonObject();
            this.extraRecipeMappings.forEach((arg_0, arg_1) -> ((JsonObject)mappings).addProperty(arg_0, arg_1));
            json.add("extra_recipe_mappings", (JsonElement)mappings);
        }
        files.accept(JsonFile.create((JsonElement)json, "data", this.bookId.m_135827_(), "patchouli_books", this.bookId.m_135815_(), "en_us", "entries", this.path.m_135815_()));
        return this;
    }

    public PatchouliEntryBuilder name(String name) {
        this.name = name;
        this.addLangEntryForName = true;
        return this;
    }

    public PatchouliEntryBuilder name(ItemLike item) {
        this.name = item.m_5456_().m_5524_();
        this.addLangEntryForName = false;
        return this;
    }

    public PatchouliEntryBuilder category(String category) {
        this.category = category;
        return this;
    }

    public PatchouliEntryBuilder icon(ItemLike icon) {
        this.icon = icon.m_5456_();
        return this;
    }

    public PatchouliEntryBuilder nameAndIcon(ItemLike icon) {
        return this.name(icon).icon(icon);
    }

    public PatchouliEntryBuilder readByDefault() {
        this.readByDefault = true;
        return this;
    }

    public PatchouliEntryBuilder advancement(String advancement) {
        this.advancement = advancement;
        return this;
    }

    public PatchouliEntryBuilder color(int color) {
        this.color = color;
        return this;
    }

    public PatchouliEntryBuilder sortnum(int sortnum) {
        this.sortnum = sortnum;
        return this;
    }

    public PatchouliEntryBuilder extraRecipeMapping(ItemLike xd, int page) {
        this.extraRecipeMappings.put(Registry.f_122827_.m_7981_((Object)xd.m_5456_()).toString(), page);
        return this;
    }

    public PatchouliEntryBuilder extraRecipeMapping(ItemLike xd) {
        return this.extraRecipeMapping(xd, 0);
    }

    public PatchouliEntryBuilder challenge(String name, String text) {
        return this.category("botania:challenges").name(name).readByDefault().advancement("botania:main/mana_pool_pickup_lexicon").sortnum(69).checkboxQuest(name, text);
    }

    public PatchouliEntryBuilder devicesCategory() {
        return this.category("botania:devices");
    }

    public PatchouliEntryBuilder functionalFlowersCategory() {
        return this.category("botania:functional_flowers");
    }

    public PatchouliEntryBuilder enderCategory() {
        return this.category("botania:ender");
    }

    public PatchouliEntryBuilder miscCategory() {
        return this.category("botania:misc");
    }

    public PatchouliEntryBuilder toolsCategory() {
        return this.category("botania:tools");
    }

    public PatchouliEntryBuilder elven() {
        return this.advancement("botania:main/elf_lexicon_pickup");
    }

    public PatchouliEntryBuilder text(String text) {
        this.pages.add((json, langKeyMaker) -> {
            json.addProperty("type", "patchouli:text");
            json.addProperty("text", langKeyMaker.associate("text", text));
        });
        return this;
    }

    public PatchouliEntryBuilder spotlight(ItemLike spotlight, boolean linkRecipe, String text) {
        this.pages.add((json, langKeyMaker) -> {
            json.addProperty("type", "patchouli:spotlight");
            json.addProperty("item", this.itemStackString(new ItemStack(spotlight)));
            json.addProperty("text", langKeyMaker.associate("text", text));
            if (linkRecipe) {
                json.addProperty("link_recipe", Boolean.valueOf(true));
            }
        });
        return this;
    }

    public PatchouliEntryBuilder recipe(String type, String recipeId, String text) {
        this.pages.add((json, langKeyMaker) -> {
            json.addProperty("type", type);
            json.addProperty("recipe", recipeId);
            if (text != null) {
                json.addProperty("text", langKeyMaker.associate("text", text));
            }
        });
        return this;
    }

    public PatchouliEntryBuilder crafting(String recipeId, String text) {
        return this.recipe("patchouli:crafting", recipeId, text);
    }

    public PatchouliEntryBuilder petalApothecary(String recipeId, String text) {
        return this.recipe("botania:petal_apothecary", recipeId, text);
    }

    public PatchouliEntryBuilder runicAltar(String recipeId, String text) {
        return this.recipe("botania:runic_altar", recipeId, text);
    }

    public PatchouliEntryBuilder crafting(ItemLike thing, String text) {
        return this.crafting(Registry.f_122827_.m_7981_((Object)thing.m_5456_()).toString(), text);
    }

    public PatchouliEntryBuilder petalApothecary(ItemLike thing, String text) {
        return this.petalApothecary(DataDsl.prefixPath(Registry.f_122827_.m_7981_((Object)thing.m_5456_()), "petal_apothecary").toString(), text);
    }

    public PatchouliEntryBuilder runicAltar(ItemLike thing, String text) {
        return this.runicAltar(DataDsl.prefixPath(Registry.f_122827_.m_7981_((Object)thing.m_5456_()), "runic_altar").toString(), text);
    }

    public PatchouliEntryBuilder craftingMulti(Iterable<String> multi, String text) {
        this.pages.add((json, langKeyMaker) -> {
            json.addProperty("type", "botania:crafting_multi");
            json.add("recipes", (JsonElement)PatchouliEntryBuilder.jsonArrayStrings(multi));
            if (text != null) {
                json.addProperty("text", langKeyMaker.associate("text", text));
            }
        });
        return this;
    }

    public PatchouliEntryBuilder craftingMulti(Collection<? extends ItemLike> yes, String text) {
        return this.craftingMulti(yes.stream().map(ItemLike::m_5456_).map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_7981_(arg_0)).map(ResourceLocation::toString).collect(Collectors.toList()), text);
    }

    public PatchouliEntryBuilder checkboxQuest(String title, String text) {
        this.pages.add((json, langKeyMaker) -> {
            json.addProperty("type", "patchouli:quest");
            json.addProperty("title", langKeyMaker.associate("title", title));
            json.addProperty("text", langKeyMaker.associate("text", text));
        });
        return this;
    }

    public PatchouliEntryBuilder relations(@Nullable String title, @Nullable String text, Object ... others) {
        List relations = Stream.of(others).map(other -> {
            if (other instanceof PatchouliEntryBuilder) {
                PatchouliEntryBuilder entry = (PatchouliEntryBuilder)other;
                return entry.path.toString();
            }
            return other.toString();
        }).collect(Collectors.toList());
        this.pages.add((json, langKeyMaker) -> {
            json.addProperty("type", "patchouli:relations");
            json.add("entries", (JsonElement)PatchouliEntryBuilder.jsonArrayStrings(relations));
            if (title != null) {
                json.addProperty("title", langKeyMaker.associate("title", title));
            }
            if (text != null) {
                json.addProperty("text", langKeyMaker.associate("text", text));
            }
        });
        return this;
    }

    public PatchouliEntryBuilder relations0(Object ... others) {
        return this.relations(null, null, others);
    }

    private String itemStackString(ItemStack stack) {
        return Registry.f_122827_.m_7981_((Object)stack.m_41720_()).toString();
    }

    private String langKey(Object ... ext) {
        return Stream.concat(Stream.of(this.langBase), Stream.of(ext).map(Object::toString)).collect(Collectors.joining("."));
    }

    private static JsonArray jsonArrayStrings(Iterable<String> blah) {
        JsonArray yes = new JsonArray();
        blah.forEach(arg_0 -> ((JsonArray)yes).add(arg_0));
        return yes;
    }

    public static interface Page {
        public void toJson(JsonObject var1, LangKeyMaker var2);

        default public JsonObject toJson(LangKeyMaker langKeyMaker) {
            JsonObject yes = new JsonObject();
            this.toJson(yes, langKeyMaker);
            return yes;
        }
    }

    public static interface LangKeyMaker {
        public String associate(String var1, String var2);
    }
}

