/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.datagen;

import agency.highlysuspect.incorporeal.datagen.DataDsl;
import agency.highlysuspect.incorporeal.datagen.JsonFile;
import agency.highlysuspect.incorporeal.datagen.ManaInfusionRecipeBuilder;
import agency.highlysuspect.incorporeal.datagen.PetalApothecaryRecipeBuilder;
import agency.highlysuspect.incorporeal.datagen.RunicAltarRecipeBuilder;
import agency.highlysuspect.incorporeal.datagen.StonecuttingRecipeBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.mixin.AccessorRecipeProvider;

public class RecipeDsl {
    public static NiceShapedRecipeBuilder shaped(ItemLike out, int count, String ... lines) {
        ShapedRecipeBuilder inner = new ShapedRecipeBuilder(out, count);
        for (String line : lines) {
            inner.m_126130_(line);
        }
        return new NiceShapedRecipeBuilder(inner);
    }

    public static NiceShapedRecipeBuilder shaped(ItemLike out, String ... lines) {
        return RecipeDsl.shaped(out, 1, lines);
    }

    public static NiceShapelessRecipeBuilder shapeless(ItemLike out, int count) {
        return new NiceShapelessRecipeBuilder(ShapelessRecipeBuilder.m_126191_((ItemLike)out, (int)count));
    }

    public static NiceShapelessRecipeBuilder shapeless(ItemLike out) {
        return RecipeDsl.shapeless(out, 1);
    }

    public static NiceShapedRecipeBuilder compress9(ItemLike small, ItemLike big) {
        return RecipeDsl.shaped(big, "###", "###", "###").define((Object)"#", small);
    }

    public static NiceShapelessRecipeBuilder uncompressTo9(ItemLike big, ItemLike small) {
        return RecipeDsl.shapeless(small, 9).add(big);
    }

    public static StonecuttingRecipeBuilder.Group stonecuttingGroup(Iterable<? extends ItemLike> inputs) {
        ArrayList<ItemLike> wow = new ArrayList<ItemLike>();
        inputs.forEach(wow::add);
        return StonecuttingRecipeBuilder.Group.create0(wow);
    }

    public static StonecuttingRecipeBuilder stonecutting(ItemLike output) {
        return StonecuttingRecipeBuilder.create(output);
    }

    public static NiceShapelessRecipeBuilder floatingFlower(ItemLike notFloating, ItemLike floating) {
        return RecipeDsl.shapeless(floating).add(notFloating).add((TagKey<Item>)ModTags.Items.FLOATING_FLOWERS);
    }

    public static RunicAltarRecipeBuilder runic(ItemLike out, int mana) {
        return RunicAltarRecipeBuilder.create(out, mana);
    }

    public static PetalApothecaryRecipeBuilder apothecary(ItemLike out) {
        return PetalApothecaryRecipeBuilder.create(out);
    }

    public static ManaInfusionRecipeBuilder infusion(ItemLike out, int mana) {
        return ManaInfusionRecipeBuilder.create(out, mana);
    }

    public static ManaInfusionRecipeBuilder miniFlower(ItemLike big, ItemLike small) {
        return RecipeDsl.infusion(small, 2500).input(big).alchemyCatalyst().group("botania:flower_shrinking");
    }

    public static void save(Consumer<JsonFile> fileConsumer, RecipeBuilder builder) {
        RecipeDsl.save(fileConsumer, builder, RecipeBuilder.m_176493_((ItemLike)builder.m_142372_()));
    }

    public static void save(Consumer<JsonFile> fileConsumer, RecipeBuilder builder, ResourceLocation id) {
        DataDsl.notAir(id);
        builder.m_142700_(finishedRecipe -> {
            JsonObject recipeJson = finishedRecipe.m_125966_();
            fileConsumer.accept(JsonFile.create((JsonElement)recipeJson, "data", id.m_135827_(), "recipes", id.m_135815_()));
            JsonObject advancementJson = finishedRecipe.m_5860_();
            if (advancementJson != null) {
                fileConsumer.accept(JsonFile.create((JsonElement)advancementJson, "data", id.m_135827_(), "advancements/recipes/" + id.m_135827_(), id.m_135815_()));
            }
        }, id);
    }

    private static char toChar(Object key) {
        if (key instanceof Character) {
            Character c = (Character)key;
            return c.charValue();
        }
        if (key instanceof String) {
            String s = (String)key;
            return s.charAt(0);
        }
        throw new IllegalArgumentException();
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromTag(TagKey<Item> tag) {
        return AccessorRecipeProvider.botania_condition((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_()});
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromItem(ItemLike item) {
        return AccessorRecipeProvider.botania_condition((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_()});
    }

    public record NiceShapedRecipeBuilder(ShapedRecipeBuilder inner) {
        public NiceShapedRecipeBuilder define(Object key, ItemLike ingredient) {
            this.inner.m_126127_(Character.valueOf(RecipeDsl.toChar(key)), ingredient);
            this.inner.m_142284_(DataDsl.notAir(Registry.f_122827_.m_7981_((Object)ingredient.m_5456_())).m_135815_(), (CriterionTriggerInstance)RecipeDsl.conditionsFromItem(ingredient));
            return this;
        }

        public NiceShapedRecipeBuilder define(Object key, TagKey<Item> ingredient) {
            this.inner.m_206416_(Character.valueOf(RecipeDsl.toChar(key)), ingredient);
            this.inner.m_142284_(ingredient.f_203868_().m_135815_(), (CriterionTriggerInstance)RecipeDsl.conditionsFromTag(ingredient));
            return this;
        }

        public NiceShapedRecipeBuilder group(String group) {
            this.inner.m_142409_(group);
            return this;
        }

        public void save(Consumer<JsonFile> files) {
            RecipeDsl.save(files, (RecipeBuilder)this.inner);
        }

        public void save(Consumer<JsonFile> files, ResourceLocation id) {
            RecipeDsl.save(files, (RecipeBuilder)this.inner, id);
        }
    }

    public record NiceShapelessRecipeBuilder(ShapelessRecipeBuilder inner) {
        public NiceShapelessRecipeBuilder add(ItemLike ingredient) {
            return this.add(ingredient, 1);
        }

        public NiceShapelessRecipeBuilder add(TagKey<Item> tag) {
            return this.add(tag, 1);
        }

        public NiceShapelessRecipeBuilder add(ItemLike ingredient, int count) {
            this.inner.m_126211_(ingredient, count);
            this.inner.m_142284_(DataDsl.notAir(Registry.f_122827_.m_7981_((Object)ingredient.m_5456_())).m_135815_(), (CriterionTriggerInstance)RecipeDsl.conditionsFromItem(ingredient));
            return this;
        }

        public NiceShapelessRecipeBuilder add(TagKey<Item> tag, int count) {
            this.inner.m_126186_(Ingredient.m_204132_(tag), count);
            this.inner.m_142284_(tag.f_203868_().m_135815_(), (CriterionTriggerInstance)RecipeDsl.conditionsFromTag(tag));
            return this;
        }

        public void save(Consumer<JsonFile> files) {
            RecipeDsl.save(files, (RecipeBuilder)this.inner);
        }

        public void save(Consumer<JsonFile> files, ResourceLocation id) {
            RecipeDsl.save(files, (RecipeBuilder)this.inner, id);
        }
    }
}

