/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.datagen;

import agency.highlysuspect.incorporeal.datagen.DataDsl;
import agency.highlysuspect.incorporeal.datagen.JsonFile;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.common.helper.ItemNBTHelper;

public record RunicAltarRecipeBuilder(ItemStack output, int mana, List<Ingredient> ingredients) {
    public static final int TIER_1 = 5200;
    public static final int TIER_2 = 8000;
    public static final int TIER_3 = 12000;

    public static RunicAltarRecipeBuilder create(ItemStack output, int mana) {
        return new RunicAltarRecipeBuilder(output, mana, new ArrayList<Ingredient>());
    }

    public static RunicAltarRecipeBuilder create(ItemLike output, int mana) {
        return new RunicAltarRecipeBuilder(new ItemStack(output), mana, new ArrayList<Ingredient>());
    }

    public static RunicAltarRecipeBuilder create(ItemLike output, int count, int mana) {
        return new RunicAltarRecipeBuilder(new ItemStack(output, count), mana, new ArrayList<Ingredient>());
    }

    public RunicAltarRecipeBuilder add(ItemLike item) {
        this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public RunicAltarRecipeBuilder add(ItemLike item, int count) {
        for (int i = 0; i < count; ++i) {
            this.add(item);
        }
        return this;
    }

    public RunicAltarRecipeBuilder add(TagKey<Item> item) {
        this.ingredients.add(Ingredient.m_204132_(item));
        return this;
    }

    public RunicAltarRecipeBuilder add(TagKey<Item> item, int count) {
        for (int i = 0; i < count; ++i) {
            this.add(item);
        }
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "botania:runic_altar");
        json.add("output", (JsonElement)ItemNBTHelper.serializeStack((ItemStack)this.output));
        JsonArray ingredients = new JsonArray();
        for (Ingredient ingr : this.ingredients) {
            ingredients.add(ingr.m_43942_());
        }
        json.addProperty("mana", (Number)this.mana);
        json.add("ingredients", (JsonElement)ingredients);
        return json;
    }

    public void save(Consumer<JsonFile> fileConsumer) {
        this.save(fileConsumer, RecipeBuilder.m_176493_((ItemLike)this.output.m_41720_()));
    }

    public void save(Consumer<JsonFile> fileConsumer, ResourceLocation id) {
        DataDsl.notAir(id);
        fileConsumer.accept(JsonFile.create((JsonElement)this.toJson(), "data", id.m_135827_(), "recipes", "runic_altar", id.m_135815_()));
    }
}

