/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.datagen;

import agency.highlysuspect.incorporeal.datagen.DataDsl;
import agency.highlysuspect.incorporeal.datagen.JsonFile;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class StonecuttingRecipeBuilder {
    private final List<ItemStack> ingredients = new ArrayList<ItemStack>();
    private final ItemStack output;
    @Nullable
    private String group;

    public StonecuttingRecipeBuilder(ItemStack output) {
        this.output = output;
    }

    public static StonecuttingRecipeBuilder create(ItemStack output) {
        return new StonecuttingRecipeBuilder(output);
    }

    public static StonecuttingRecipeBuilder create(ItemLike output) {
        return StonecuttingRecipeBuilder.create(new ItemStack(output));
    }

    public StonecuttingRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public StonecuttingRecipeBuilder input(Collection<ItemStack> stacks) {
        this.ingredients.addAll(stacks);
        return this;
    }

    public StonecuttingRecipeBuilder input(ItemStack ... stacks) {
        return this.input(List.of(stacks));
    }

    public StonecuttingRecipeBuilder input0(Collection<ItemLike> inputs) {
        inputs.stream().map(ItemStack::new).forEach(this.ingredients::add);
        return this;
    }

    public StonecuttingRecipeBuilder input(ItemLike ... input) {
        return this.input0(List.of(input));
    }

    public JsonObject toJson() {
        Ingredient coalescedIngredient = Ingredient.m_43921_(this.ingredients.stream());
        return new SingleItemRecipeBuilder.Result(null, RecipeSerializer.f_44095_, this.group == null ? "" : this.group, coalescedIngredient, this.output.m_41720_(), this.output.m_41613_(), null, null).m_125966_();
    }

    public void save(Consumer<JsonFile> fileConsumer) {
        this.save(fileConsumer, RecipeBuilder.m_176493_((ItemLike)this.output.m_41720_()));
    }

    public void save(Consumer<JsonFile> fileConsumer, ResourceLocation id) {
        DataDsl.notAir(id);
        fileConsumer.accept(JsonFile.create((JsonElement)this.toJson(), "data", id.m_135827_(), "recipes", "stonecutting", id.m_135815_()));
    }

    public static class Group {
        private final List<ItemStack> inputs;
        private String group;

        public Group(List<ItemStack> inputs) {
            this.inputs = inputs;
        }

        public static Group create(List<ItemStack> inputs) {
            return new Group(inputs);
        }

        public static Group create(ItemStack ... inputs) {
            return Group.create(List.of(inputs));
        }

        public static Group create0(List<ItemLike> inputs) {
            return new Group(inputs.stream().map(ItemStack::new).collect(Collectors.toList()));
        }

        public static Group create0(ItemLike ... inputs) {
            return Group.create0(List.of(inputs));
        }

        public Group group(String group) {
            this.group = group;
            return this;
        }

        public void save(Consumer<JsonFile> fileConsumer) {
            for (int i = 0; i < this.inputs.size(); ++i) {
                ItemStack output = this.inputs.get(i);
                ResourceLocation id = DataDsl.prefixPath(RecipeBuilder.m_176493_((ItemLike)output.m_41720_()), this.group);
                ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(this.inputs);
                inputs.remove(i);
                StonecuttingRecipeBuilder.create(output).group(this.group).input(inputs).save(fileConsumer, id);
            }
        }
    }
}

