/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.entity;

import agency.highlysuspect.incorporeal.IncEntityTypes;
import agency.highlysuspect.incorporeal.IncItems;
import agency.highlysuspect.incorporeal.item.FracturedSpaceRodItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.xplat.IXplatAbstractions;

public class FracturedSpaceCollector
extends Entity {
    private BlockPos cratePos;
    private UUID ownerUuid;
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.m_135353_(FracturedSpaceCollector.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double RADIUS = 2.0;
    private static final int MAX_AGE = 30;
    private static final int AGE_SPECIAL_START = 22;
    private static final int MANA_COST_PER_ITEM = 500;
    private static final ItemStack TOOL_STACK = new ItemStack((ItemLike)IncItems.FRACTURED_SPACE_ROD);
    private static final int CHUNK_LOAD_TIMEOUT = 300;
    private static final int CHUNK_LOAD_RADIUS = 3;
    private static final TicketType<Unit> CHUNK_LOAD_REASON = TicketType.m_9465_((String)"incorporeal:fracturedspace", (x, y) -> 0, (int)300);

    public FracturedSpaceCollector(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public FracturedSpaceCollector(Level level, BlockPos cratePos, UUID ownerUuid) {
        this(IncEntityTypes.FRACTURED_SPACE_COLLECTOR, level);
        this.cratePos = cratePos;
        this.ownerUuid = ownerUuid;
    }

    public void m_8119_() {
        super.m_8119_();
        int age = this.getAge() + 1;
        this.setAge(age);
        if (this.f_19853_.m_5776_()) {
            this.doSparkles(age);
        } else if (age > 22) {
            List nearbyItemEnts = this.f_19853_.m_6443_(ItemEntity.class, this.m_142469_(), ent -> ent != null && ent.m_6084_() && Math.hypot(this.m_20185_() - ent.m_20185_(), this.m_20189_() - ent.m_20189_()) <= 2.0);
            for (ItemEntity ent2 : nearbyItemEnts) {
                double dx = this.m_20185_() - ent2.m_20185_();
                double dz = this.m_20189_() - ent2.m_20189_();
                ent2.m_20256_(ent2.m_20184_().m_82520_(dx * 0.3, 0.0, dz * 0.3));
                ent2.f_19812_ = true;
            }
            if (age >= 30) {
                BlockState stateThere;
                if (this.ownerUuid == null) {
                    this.m_146870_();
                    return;
                }
                Player player = this.f_19853_.m_46003_(this.ownerUuid);
                if (player == null) {
                    this.m_146870_();
                    return;
                }
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel slevel = (ServerLevel)level;
                    slevel.m_7726_().m_8387_(CHUNK_LOAD_REASON, new ChunkPos(this.cratePos), 3, (Object)Unit.INSTANCE);
                }
                if (!FracturedSpaceRodItem.isCrate(stateThere = this.f_19853_.m_8055_(this.cratePos)) || !this.canEject(this.cratePos)) {
                    this.m_146870_();
                    return;
                }
                for (ItemEntity ent3 : nearbyItemEnts) {
                    ItemStack stack = ent3.m_32055_();
                    int count = stack.m_41613_();
                    int cost = count * 500;
                    if (!ManaItemHandler.instance().requestManaExact(TOOL_STACK, player, cost, false)) continue;
                    ManaItemHandler.instance().requestManaExact(TOOL_STACK, player, cost, true);
                    this.eject(this.cratePos, stack);
                    ent3.m_146870_();
                }
            }
        }
        if (age >= 30) {
            this.m_146870_();
        }
    }

    public boolean canEject(BlockPos worldPosition) {
        float width = EntityType.f_20461_.m_20678_();
        float height = EntityType.f_20461_.m_20679_();
        double ejectX = (double)worldPosition.m_123341_() + 0.5;
        double ejectY = (float)worldPosition.m_123342_() - height;
        double ejectZ = (double)worldPosition.m_123343_() + 0.5;
        AABB itemBB = new AABB(ejectX - (double)(width / 2.0f), ejectY, ejectZ - (double)(width / 2.0f), ejectX + (double)(width / 2.0f), ejectY + (double)height, ejectZ + (double)(width / 2.0f));
        return this.f_19853_.m_45772_(itemBB);
    }

    public void eject(BlockPos worldPosition, ItemStack stack) {
        boolean redstone = this.f_19853_.m_46753_(worldPosition);
        double ejectY = (float)worldPosition.m_123342_() - EntityType.f_20461_.m_20679_();
        ItemEntity item = new ItemEntity(this.f_19853_, (double)worldPosition.m_123341_() + 0.5, ejectY, (double)worldPosition.m_123343_() + 0.5, stack);
        item.m_20256_(Vec3.f_82478_);
        if (redstone) {
            IXplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).timeCounter = -200;
        }
        this.f_19853_.m_7967_((Entity)item);
    }

    private void doSparkles(int age) {
        int PARTICLE_COUNT = 12;
        double ageFraction = (double)age / 30.0;
        double radiusMult = 1.6 * (ageFraction - Math.pow(ageFraction, 7.0));
        double particleAngle = (double)age / 25.0;
        double height = radiusMult / 2.0;
        int i = 0;
        while (i < PARTICLE_COUNT) {
            double x = Math.cos(particleAngle) * 2.0 * radiusMult;
            double z = Math.sin(particleAngle) * 2.0 * radiusMult;
            float size = (float)(1.0 + ageFraction * 5.0 * Math.random());
            SparkleParticleData uwu = SparkleParticleData.sparkle((float)size, (float)0.1f, (float)0.85f, (float)0.65f, (int)5);
            this.f_19853_.m_7106_((ParticleOptions)uwu, this.m_20185_() + x, this.m_20186_() + height, this.m_20189_() + z, 0.0, 0.0, 0.0);
            ++i;
            particleAngle += Math.PI * 2 / (double)PARTICLE_COUNT;
        }
        double x = Math.cos(Math.random() * Math.PI * 2.0) * 2.0 * radiusMult;
        double z = Math.cos(Math.random() * Math.PI * 2.0) * 2.0 * radiusMult;
        WispParticleData awa = WispParticleData.wisp((float)0.5f, (float)0.1f, (float)85.0f, (float)0.65f, (float)0.5f);
        this.f_19853_.m_7106_((ParticleOptions)awa, this.m_20185_() + x, this.m_20186_() + height, this.m_20189_() + z, 0.0, 0.0, 0.0);
        if (age >= 28) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            SparkleParticleData uwu = SparkleParticleData.sparkle((float)2.0f, (float)0.9f, (float)0.45f, (float)0.05f, (int)2);
            for (int i2 = 0; i2 < 5; ++i2) {
                this.f_19853_.m_7106_((ParticleOptions)uwu, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    private int getAge() {
        return (Integer)this.m_20088_().m_135370_(DATA_AGE);
    }

    private void setAge(int age) {
        this.m_20088_().m_135381_(DATA_AGE, (Object)age);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_AGE, (Object)0);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("Age", this.getAge());
        tag.m_128362_("Owner", this.ownerUuid);
        tag.m_128365_("CratePos", (Tag)NbtUtils.m_129224_((BlockPos)this.cratePos));
    }

    protected void m_7378_(CompoundTag tag) {
        this.setAge(tag.m_128451_("Age"));
        this.ownerUuid = tag.m_128342_("Owner");
        this.cratePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("CratePos"));
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

