/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.item;

import agency.highlysuspect.incorporeal.block.entity.AbstractSoulCoreBlockEntity;
import agency.highlysuspect.incorporeal.util.MoreNbtHelpers;
import agency.highlysuspect.incorporeal.util.ServerPlayerDuck;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class BoundEnderPearlItem
extends Item {
    public static final String OWNER_KEY = "BoundOwner";
    public static final String OWNER_NAME_KEY = "BoundOwnerName";
    public static final String EPOCH_KEY = "BoundEpoch";
    public static final int TOTAL_CHARGES = 10;
    public static final int MANA_PER_CHARGE = 1000;
    public static final int MANA_CONTAINER_SIZE = 10000;
    public static final int MANA_RECHARGE_RATE = 10;

    public BoundEnderPearlItem(Item.Properties props) {
        super(props);
    }

    @Nullable
    public UUID getOwnerUuid(ItemStack stack) {
        return MoreNbtHelpers.getUuid(stack, OWNER_KEY, null);
    }

    @Nullable
    public String getOwnerName(ItemStack stack) {
        return ItemNBTHelper.getString((ItemStack)stack, (String)OWNER_NAME_KEY, null);
    }

    public int getEpoch(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)EPOCH_KEY, (int)0);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(ManaBarTooltip.fromManaItem((ItemStack)stack));
    }

    public void bindTo(ItemStack stack, ServerPlayer player) {
        MoreNbtHelpers.setUuid(stack, OWNER_KEY, player.m_142081_());
        ItemNBTHelper.setString((ItemStack)stack, (String)OWNER_NAME_KEY, (String)player.m_36316_().getName());
        ItemNBTHelper.setInt((ItemStack)stack, (String)EPOCH_KEY, (int)((ServerPlayerDuck)player).inc$getEpoch());
        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
        if (manaItem != null) {
            manaItem.addMana(manaItem.getMaxMana());
        }
    }

    public void payMana(@Nullable Player player, @Nullable InteractionHand hand, ItemStack stack) {
        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
        if (manaItem == null) {
            return;
        }
        manaItem.addMana(-1000);
        if (manaItem.getMana() <= 0) {
            stack.m_41764_(0);
            if (player != null && hand != null) {
                player.m_21008_(hand, ItemStack.f_41583_);
                player.m_21190_(hand);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
        if (manaItem == null) {
            return;
        }
        int howMuchToRequest = Math.min(manaItem.getMaxMana() - manaItem.getMana(), 10);
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (manaItem.getMana() <= manaItem.getMaxMana() && ManaItemHandler.instance().requestManaExactForTool(stack, player, howMuchToRequest, true)) {
                manaItem.addMana(howMuchToRequest);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        UUID ownerUuid = this.getOwnerUuid(stack);
        if (ownerUuid == null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                this.bindTo(stack, splayer);
                player.m_6469_(AbstractSoulCoreBlockEntity.SOUL, 2.0f);
            }
        } else {
            level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11857_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_5822_().nextFloat() * 0.4f + 0.8f));
            if (level instanceof ServerLevel) {
                ServerLevel slevel = (ServerLevel)level;
                ServerPlayer owner = slevel.m_142572_().m_6846_().m_11259_(ownerUuid);
                if (owner == null || owner.f_19853_ != level) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                if (this.getEpoch(stack) != ((ServerPlayerDuck)owner).inc$getEpoch()) {
                    player.m_5661_((Component)new TranslatableComponent("incorporeal.bound_ender_pearl.dissolve").m_130940_(ChatFormatting.BLUE), true);
                    player.m_21190_(hand);
                    player.m_21008_(hand, ItemStack.f_41583_);
                    return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
                }
                BoundEnderPearlItem.yeetEnderpearl(slevel, (Player)owner, stack, pearl -> pearl.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f));
                this.payMana(player, hand, stack);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag whyTho) {
        super.m_7373_(stack, level, tooltip, whyTho);
        if (level == null) {
            return;
        }
        String ownerName = this.getOwnerName(stack);
        if (ownerName == null) {
            tooltip.add((Component)new TranslatableComponent("incorporeal.bound_ender_pearl.notBound").m_130940_(ChatFormatting.RED));
        } else {
            MutableComponent ownerComponent = new TextComponent(ownerName).m_130940_(ChatFormatting.GOLD);
            tooltip.add((Component)new TranslatableComponent("incorporeal.bound_ender_pearl.boundTo", new Object[]{ownerComponent}));
        }
        if (whyTho.m_7050_()) {
            UUID ownerUuid = this.getOwnerUuid(stack);
            if (ownerUuid != null) {
                tooltip.add((Component)new TextComponent(ownerUuid.toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            tooltip.add((Component)new TranslatableComponent("incorporeal.bound_ender_pearl.epoch", new Object[]{this.getEpoch(stack)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    private static void yeetEnderpearl(ServerLevel slevel, Player owner, ItemStack stack, Consumer<ThrownEnderpearl> pearlConfigurator) {
        ThrownEnderpearl pearl = new ThrownEnderpearl((Level)slevel, (LivingEntity)owner);
        pearlConfigurator.accept(pearl);
        pearl.m_37446_(stack);
        slevel.m_7967_((Entity)pearl);
    }

    public record ManaItem(BoundEnderPearlItem item, ItemStack stack) implements IManaItem
    {
        public static final String MANA_KEY = "Mana";

        public int getMana() {
            return ItemNBTHelper.getInt((ItemStack)this.stack, (String)MANA_KEY, (int)0);
        }

        public int getMaxMana() {
            return 10000;
        }

        public void addMana(int mana) {
            ItemNBTHelper.setInt((ItemStack)this.stack, (String)MANA_KEY, (int)Mth.m_14045_((int)(this.getMana() + mana), (int)0, (int)this.getMaxMana()));
        }

        public boolean canReceiveManaFromPool(BlockEntity be) {
            return this.item.getOwnerUuid(this.stack) != null;
        }

        public boolean canReceiveManaFromItem(ItemStack otherStack) {
            return this.item.getOwnerUuid(this.stack) != null;
        }

        public boolean canExportManaToPool(BlockEntity pool) {
            return false;
        }

        public boolean canExportManaToItem(ItemStack otherStack) {
            return false;
        }

        public boolean isNoExport() {
            return true;
        }
    }

    public class DispenseBehavior
    extends OptionalDispenseItemBehavior {
        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            ServerLevel slevel = source.m_7727_();
            UUID ownerUuid = BoundEnderPearlItem.this.getOwnerUuid(stack);
            if (ownerUuid == null) {
                this.m_123573_(false);
                return stack;
            }
            ServerPlayer owner = slevel.m_142572_().m_6846_().m_11259_(ownerUuid);
            if (owner == null || owner.f_19853_ != slevel) {
                this.m_123573_(false);
                return stack;
            }
            if (BoundEnderPearlItem.this.getEpoch(stack) != ((ServerPlayerDuck)owner).inc$getEpoch()) {
                this.m_123573_(true);
                return stack;
            }
            Position pos = DispenserBlock.m_52720_((BlockSource)source);
            Direction dir = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BoundEnderPearlItem.yeetEnderpearl(slevel, (Player)owner, stack, pearl -> {
                pearl.m_6034_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
                pearl.m_6686_((double)dir.m_122429_(), (double)((float)dir.m_122430_() + 0.1f), (double)dir.m_122431_(), 1.1f, 6.0f);
            });
            BoundEnderPearlItem.this.payMana(null, null, stack);
            this.m_123573_(true);
            return stack;
        }
    }
}

