/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.item;

import agency.highlysuspect.incorporeal.entity.FracturedSpaceCollector;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.ICoordBoundItem;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;

public class FracturedSpaceRodItem
extends Item {
    private static final String POS = "CratePos";
    private static final String DIMENSION = "CrateDimension";

    public FracturedSpaceRodItem(Item.Properties $$0) {
        super($$0);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        if (!PlayerHelper.isTruePlayer((Entity)player)) {
            return InteractionResult.FAIL;
        }
        Level level = ctx.m_43725_();
        ItemStack held = ctx.m_43722_();
        BlockPos pos = ctx.m_8083_();
        BlockState hitState = level.m_8055_(pos);
        if (FracturedSpaceRodItem.isCrate(hitState)) {
            ItemNBTHelper.setCompound((ItemStack)held, (String)POS, (CompoundTag)NbtUtils.m_129224_((BlockPos)pos));
            ItemNBTHelper.setString((ItemStack)held, (String)DIMENSION, (String)FracturedSpaceRodItem.stringifyDimension(level));
            FracturedSpaceRodItem.status(player, (Component)FracturedSpaceRodItem.t("incorporeal.fractured_space.saved", new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE));
        } else {
            if (ctx.m_43719_() != Direction.UP) {
                return InteractionResult.PASS;
            }
            CompoundTag cratePosCmp = ItemNBTHelper.getCompound((ItemStack)held, (String)POS, (boolean)true);
            String crateDimensionStr = ItemNBTHelper.getString((ItemStack)held, (String)DIMENSION, null);
            if (cratePosCmp == null || crateDimensionStr == null) {
                FracturedSpaceRodItem.status(player, (Component)FracturedSpaceRodItem.t("incorporeal.fractured_space.no_pos", new Object[0]).m_130940_(ChatFormatting.RED));
                return InteractionResult.FAIL;
            }
            if (!FracturedSpaceRodItem.stringifyDimension(level).equals(crateDimensionStr)) {
                FracturedSpaceRodItem.status(player, (Component)FracturedSpaceRodItem.t("incorporeal.fractured_space.wrong_dimension", new Object[0]).m_130940_(ChatFormatting.RED));
                return InteractionResult.FAIL;
            }
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            BlockPos cratePos = NbtUtils.m_129239_((CompoundTag)cratePosCmp);
            BlockState stateThere = level.m_8055_(cratePos);
            if (!FracturedSpaceRodItem.isCrate(stateThere)) {
                FracturedSpaceRodItem.status(player, (Component)FracturedSpaceRodItem.t("incorporeal.fractured_space.no_crate_there", new Object[0]).m_130940_(ChatFormatting.RED));
                return InteractionResult.FAIL;
            }
            FracturedSpaceCollector collector = new FracturedSpaceCollector(level, cratePos, player.m_142081_());
            collector.m_6034_(ctx.m_43720_().f_82479_, pos.m_123342_() + 1, ctx.m_43720_().f_82481_);
            level.m_7967_((Entity)collector);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag why) {
        if (level == null) {
            return;
        }
        CompoundTag cratePosCmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)POS, (boolean)true);
        if (cratePosCmp == null) {
            tooltip.add((Component)FracturedSpaceRodItem.t("incorporeal.fractured_space.tooltip.not_bound", new Object[0]).m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)FracturedSpaceRodItem.t("incorporeal.fractured_space.tooltip.bound", new Object[0]).m_130940_(ChatFormatting.GREEN));
            String dimensionStr = ItemNBTHelper.getString((ItemStack)stack, (String)DIMENSION, null);
            if (dimensionStr == null || !FracturedSpaceRodItem.stringifyDimension(level).equals(dimensionStr)) {
                tooltip.add((Component)FracturedSpaceRodItem.t("incorporeal.fractured_space.tooltip.wrong_dimension", new Object[0]).m_130940_(ChatFormatting.RED));
            }
            if (why.m_7050_()) {
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)cratePosCmp);
                tooltip.add((Component)FracturedSpaceRodItem.t("incorporeal.fractured_space.tooltip.debug.pos", pos.m_123341_(), pos.m_123342_(), pos.m_123343_()).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)FracturedSpaceRodItem.t("incorporeal.fractured_space.tooltip.debug.dim", dimensionStr).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public static boolean isCrate(BlockState state) {
        return state.m_60713_(ModBlocks.openCrate);
    }

    private static String stringifyDimension(Level level) {
        return level.m_46472_().m_135782_().toString();
    }

    private static void status(Player player, Component component) {
        player.m_5661_(component, true);
    }

    private static TranslatableComponent t(String key, Object ... formatStringArgs) {
        return new TranslatableComponent(key, formatStringArgs);
    }

    public record CoordBoundItem(ItemStack stack) implements ICoordBoundItem
    {
        @Nullable
        public BlockPos getBinding(Level level) {
            CompoundTag cratePosCmp = ItemNBTHelper.getCompound((ItemStack)this.stack, (String)FracturedSpaceRodItem.POS, (boolean)true);
            if (cratePosCmp == null) {
                return null;
            }
            String dimensionStr = ItemNBTHelper.getString((ItemStack)this.stack, (String)FracturedSpaceRodItem.DIMENSION, null);
            if (dimensionStr == null || !FracturedSpaceRodItem.stringifyDimension(level).equals(dimensionStr)) {
                return null;
            }
            return NbtUtils.m_129239_((CompoundTag)cratePosCmp);
        }
    }
}

