/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.item;

import agency.highlysuspect.incorporeal.computer.capabilities.DatumAcceptor;
import agency.highlysuspect.incorporeal.computer.capabilities.NotCapabilities;
import agency.highlysuspect.incorporeal.computer.types.DataType;
import agency.highlysuspect.incorporeal.computer.types.Datum;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class TicketItem<T>
extends Item {
    public final DataType<T> type;

    public TicketItem(DataType<T> type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public ItemStack produce(T thing) {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag tag = stack.m_41698_("datum");
        this.type.save(thing, tag);
        return stack;
    }

    public Datum<?> get(ItemStack stack) {
        if (!stack.m_41782_()) {
            return Datum.EMPTY;
        }
        CompoundTag tag = stack.m_41737_("datum");
        if (tag == null) {
            return Datum.EMPTY;
        }
        return this.type.datumOf(this.type.tryLoad(tag).orElse(this.type.defaultValue()));
    }

    public Component m_7626_(ItemStack stack) {
        Object key = this.m_5671_(stack);
        Datum<?> datum = this.get(stack);
        if (datum.isEmpty()) {
            key = (String)key + ".blank";
        }
        return new TranslatableComponent((String)key, new Object[]{datum.describe()});
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        @Nullable DatumAcceptor acceptor = NotCapabilities.findDatumAcceptor(ctx.m_43725_(), ctx.m_8083_(), null, null, null, true);
        if (acceptor != null) {
            acceptor.acceptDatum(this.get(ctx.m_43722_()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

