/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.net;

import agency.highlysuspect.incorporeal.net.IncNetwork;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public record FunnyEffect(BlockPos src, double sparkleHeight, List<Line> lines) implements IncNetwork.Packable
{
    public FunnyEffect(BlockPos src, double sparkleHeight) {
        this(src, sparkleHeight, new ArrayList<Line>());
    }

    public void addLineTo(BlockPos end, byte[] notes) {
        if (this.lines.size() > 127) {
            throw new IllegalStateException("too many lines!");
        }
        if (notes.length > 5) {
            throw new IllegalStateException("too many notes!");
        }
        this.lines.add(new Line(end, notes));
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    @Override
    public byte packId() {
        return 0;
    }

    @Override
    public void pack(FriendlyByteBuf buf) {
        buf.m_130064_(this.src);
        buf.writeDouble(this.sparkleHeight);
        IncNetwork.writeCollection(buf, this.lines, Line::pack);
    }

    public static FunnyEffect unpack(FriendlyByteBuf buf) {
        BlockPos src = buf.m_130135_();
        double sparkleHeight = buf.readDouble();
        List lines = IncNetwork.readCollection(buf, ArrayList::new, Line::unpack);
        return new FunnyEffect(src, sparkleHeight, lines);
    }

    public record Line(BlockPos dst, byte[] notes) {
        void pack(FriendlyByteBuf buf) {
            buf.m_130064_(this.dst);
            buf.m_130087_(this.notes);
        }

        static Line unpack(FriendlyByteBuf buf) {
            return new Line(buf.m_130135_(), buf.m_130101_(5));
        }
    }
}

