/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.platform.forge;

import agency.highlysuspect.incorporeal.Inc;
import agency.highlysuspect.incorporeal.IncBlockEntityTypes;
import agency.highlysuspect.incorporeal.IncBlocks;
import agency.highlysuspect.incorporeal.IncCommands;
import agency.highlysuspect.incorporeal.IncEntityTypes;
import agency.highlysuspect.incorporeal.IncItems;
import agency.highlysuspect.incorporeal.IncSounds;
import agency.highlysuspect.incorporeal.block.entity.EnderSoulCoreBlockEntity;
import agency.highlysuspect.incorporeal.client.IncClient;
import agency.highlysuspect.incorporeal.corporea.PlayerHeadHandler;
import agency.highlysuspect.incorporeal.platform.ConfigBuilder;
import agency.highlysuspect.incorporeal.platform.IncBootstrapper;
import agency.highlysuspect.incorporeal.platform.forge.IncForgeNetworking;
import agency.highlysuspect.incorporeal.platform.forge.block.entity.EnderSoulCoreItemHandler;
import agency.highlysuspect.incorporeal.platform.forge.config.ForgeConfigBuilder;
import com.mojang.brigadier.CommandDispatcher;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.forge.CapabilityUtil;

public class IncBootstrapForge
implements IncBootstrapper {
    @Override
    public ConfigBuilder createConfigBuilder(String filename) {
        return new ForgeConfigBuilder(filename);
    }

    private static <T extends IForgeRegistryEntry<T>> void bind(IForgeRegistry<T> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(registry.getRegistrySuperType(), event -> {
            IForgeRegistry forgeRegistry = event.getRegistry();
            source.accept((thing, name) -> {
                thing.setRegistryName(name);
                forgeRegistry.register(thing);
            });
        });
    }

    @Override
    public void registerBlocks() {
        IncBootstrapForge.bind(ForgeRegistries.BLOCKS, IncBlocks::register);
    }

    @Override
    public void registerBlockEntityTypes() {
        IncBootstrapForge.bind(ForgeRegistries.BLOCK_ENTITIES, IncBlockEntityTypes::register);
    }

    @Override
    public void registerItems() {
        IncBootstrapForge.bind(ForgeRegistries.ITEMS, IncItems::register);
    }

    @Override
    public void registerEntityTypes() {
        IncBootstrapForge.bind(ForgeRegistries.ENTITIES, IncEntityTypes::register);
    }

    @Override
    public void registerEntityAttributes() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> IncEntityTypes.registerAttributes((type, builder) -> e.put(type, builder.m_22265_())));
    }

    @Override
    public void registerSoundEvents() {
        IncBootstrapForge.bind(ForgeRegistries.SOUND_EVENTS, IncSounds::register);
    }

    @Override
    public void registerServerToClientNetworkChannelSender() {
        IncForgeNetworking.init();
    }

    @Override
    public void registerCapabilities() {
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, event -> {
            BlockEntity be = (BlockEntity)event.getObject();
            if (IncBlockEntityTypes.SELF_MANA_RECEIVER_BLOCK_ENTITY_TYPES.contains(be.m_58903_()) && be instanceof IManaReceiver) {
                IManaReceiver receiver = (IManaReceiver)be;
                event.addCapability(Inc.id("mana_receiver"), CapabilityUtil.makeProvider((Capability)BotaniaForgeCapabilities.MANA_RECEIVER, (Object)receiver));
            }
            if (IncBlockEntityTypes.SELF_WANDABLE_BLOCK_ENTITY_TYPES.contains(be.m_58903_()) && be instanceof IWandable) {
                IWandable wandable = (IWandable)be;
                event.addCapability(Inc.id("wandable"), CapabilityUtil.makeProvider((Capability)BotaniaForgeCapabilities.WANDABLE, (Object)wandable));
            }
            if (be.m_58903_() == IncBlockEntityTypes.ENDER_SOUL_CORE && be instanceof EnderSoulCoreBlockEntity) {
                EnderSoulCoreBlockEntity esc = (EnderSoulCoreBlockEntity)be;
                event.addCapability(Inc.id("inventory"), CapabilityUtil.makeProvider((Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new EnderSoulCoreItemHandler(esc)));
            }
        });
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, event -> {
            ItemStack stack = (ItemStack)event.getObject();
            Item item = stack.m_41720_();
            if (IncItems.COORD_BOUND_ITEM_MAKERS.containsKey(item)) {
                event.addCapability(Inc.id("coord_bound_item"), CapabilityUtil.makeProvider((Capability)BotaniaForgeCapabilities.COORD_BOUND_ITEM, (Object)IncItems.COORD_BOUND_ITEM_MAKERS.get(item).apply(stack)));
            }
            if (IncItems.MANA_ITEM_MAKERS.containsKey(item)) {
                event.addCapability(Inc.id("mana_item"), CapabilityUtil.makeProvider((Capability)BotaniaForgeCapabilities.MANA_ITEM, (Object)IncItems.MANA_ITEM_MAKERS.get(item).apply(stack)));
            }
        });
    }

    @Override
    public void registerCommands() {
        MinecraftForge.EVENT_BUS.addListener(e -> IncCommands.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher(), e.getEnvironment() == Commands.CommandSelection.DEDICATED));
    }

    @Override
    public void endSelfInit() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> IncClient.INSTANCE::onInitializeClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> e.enqueueWork(() -> {
            Inc.INSTANCE.markBotaniaAsDoneInitializing();
            Inc.INSTANCE.registerDispenserBehaviors();
        }));
    }

    @Override
    public void registerCorporeaIndexCallback() {
        MinecraftForge.EVENT_BUS.addListener(e -> e.setCanceled(PlayerHeadHandler.onIndexRequest(e.getRequester(), e.getMatcher(), e.getRequestCount(), e.getIndexSpark())));
    }

    @Override
    public void registerRedstoneRootPlaceEvent() {
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.getPlayer() == null || e.getWorld() == null || e.getPlayer().m_5833_()) {
                return;
            }
            ItemStack held = e.getItemStack();
            if (held.m_41720_() != ModItems.redstoneRoot) {
                return;
            }
            InteractionResult result = IncBlocks.REDSTONE_ROOT_CROP.hookRedstoneRootClick(e.getPlayer(), e.getWorld(), e.getItemStack(), e.getHand(), e.getHitVec());
            if (result != InteractionResult.PASS) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
    }
}

