/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.platform.forge.block.entity;

import agency.highlysuspect.incorporeal.block.entity.RedStringConstrictorBlockEntity;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.xplat.IXplatAbstractions;

public class ForgeRedStringConstrictorBlockEntity
extends RedStringConstrictorBlockEntity {
    public ForgeRedStringConstrictorBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public boolean acceptBlock(BlockPos pos) {
        assert (this.f_58857_ != null);
        BlockEntity be = this.f_58857_.m_7702_(pos);
        return be != null && IXplatAbstractions.INSTANCE.isRedStringContainerTarget(be);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            BlockEntity binding = this.getTileAtBinding();
            if (binding == null) {
                return LazyOptional.of(() -> EmptyHandler.INSTANCE).cast();
            }
            return binding.getCapability(cap, side).cast().lazyMap(handler -> this.sliceStorage((start, end) -> ForgeRedStringConstrictorBlockEntity.makeRangedWrapper(handler, start, end), handler.getSlots(), () -> EmptyHandler.INSTANCE)).cast();
        }
        return LazyOptional.empty();
    }

    public static IItemHandler makeRangedWrapper(IItemHandler handler, int start, int end) {
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
            return new RangedWrapper(modifiable, start, end);
        }
        return new NotIItemHandlerModifiableRangedWrapper(handler, start, end);
    }

    public static class NotIItemHandlerModifiableRangedWrapper
    implements IItemHandler {
        private final IItemHandler compose;
        private final int minSlot;
        private final int maxSlot;

        public NotIItemHandlerModifiableRangedWrapper(IItemHandler compose, int minSlot, int maxSlotExclusive) {
            Preconditions.checkArgument((maxSlotExclusive > minSlot ? 1 : 0) != 0, (Object)"Max slot must be greater than min slot");
            this.compose = compose;
            this.minSlot = minSlot;
            this.maxSlot = maxSlotExclusive;
        }

        public int getSlots() {
            return this.maxSlot - this.minSlot;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (this.checkSlot(slot)) {
                return this.compose.getStackInSlot(slot + this.minSlot);
            }
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.checkSlot(slot)) {
                return this.compose.insertItem(slot + this.minSlot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.checkSlot(slot)) {
                return this.compose.extractItem(slot + this.minSlot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            if (this.checkSlot(slot)) {
                return this.compose.getSlotLimit(slot + this.minSlot);
            }
            return 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (this.checkSlot(slot)) {
                return this.compose.isItemValid(slot + this.minSlot, stack);
            }
            return false;
        }

        private boolean checkSlot(int localSlot) {
            return localSlot + this.minSlot < this.maxSlot;
        }
    }
}

