/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.platform.forge.client;

import agency.highlysuspect.incorporeal.client.IncClientProperties;
import agency.highlysuspect.incorporeal.client.MyDynamicItemRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.Nullable;

public class IncForgeBlockEntityItemRendererHelper {
    private static final Map<Item, MyDynamicItemRenderer> rendererCache = new IdentityHashMap<Item, MyDynamicItemRenderer>();
    private static final BlockEntityWithoutLevelRenderer RENDERER = new BlockEntityWithoutLevelRenderer(null, null){

        public void m_108829_(ItemStack stack, ItemTransforms.TransformType transform, PoseStack ps, MultiBufferSource buffers, int light, int overlay) {
            MyDynamicItemRenderer renderer = IncForgeBlockEntityItemRendererHelper.findRenderer(stack.m_41720_());
            if (renderer != null) {
                renderer.render(stack, transform, ps, buffers, light, overlay);
            }
        }
    };
    public static final IItemRenderProperties PROPS = new IItemRenderProperties(){

        public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
            return RENDERER;
        }
    };

    @Nullable
    private static MyDynamicItemRenderer findRenderer(Item item) {
        return rendererCache.computeIfAbsent(item, __ -> {
            Supplier<MyDynamicItemRenderer> my = IncClientProperties.MY_DYNAMIC_ITEM_RENDERERS.get(item);
            if (my == null) {
                return null;
            }
            return my.get();
        });
    }
}

