/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.util;

import agency.highlysuspect.incorporeal.Inc;
import agency.highlysuspect.incorporeal.IncBlocks;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.Block;
import vazkii.botania.common.block.ModBlocks;

public class CompressedTaterUtil {
    public static final Map<Integer, String> prefixes = new LinkedHashMap<Integer, String>();
    public static final int SMALLEST = -4;
    public static final int LARGEST = 8;

    public static String prefix(int compressionLevel) {
        return prefixes.get(compressionLevel) + "_tiny_potato";
    }

    public static TranslatableComponent formatCount(int compressionLevel, int root) {
        int num = (int)Math.pow(root, Math.abs(compressionLevel));
        String niceFormatted = String.format("%,d", num);
        if (compressionLevel < 0) {
            return new TranslatableComponent("block.incorporeal.compressed_tiny_potatoes.tooltip.fraction", new Object[]{niceFormatted});
        }
        return new TranslatableComponent("block.incorporeal.compressed_tiny_potatoes.tooltip", new Object[]{niceFormatted});
    }

    public static float taterRadius(int compressionLevel) {
        if (compressionLevel > 0) {
            return Inc.rangeRemap(compressionLevel, 0.0f, 8.0f, 0.125f, 0.5f);
        }
        return Inc.rangeRemap(compressionLevel, 0.0f, -4.0f, 0.125f, 0.01f);
    }

    public static float taterScaleFactor(int compressionLevel) {
        return CompressedTaterUtil.taterRadius(compressionLevel) * 8.0f;
    }

    public static Block getPotato(int compressionLevel) {
        if (compressionLevel == 0) {
            return ModBlocks.tinyPotato;
        }
        return (Block)IncBlocks.COMPRESSED_TATERS.get(compressionLevel);
    }

    static {
        prefixes.put(-4, "tiny_tiny_tiny_tiny");
        prefixes.put(-3, "tiny_tiny_tiny");
        prefixes.put(-2, "tiny_tiny");
        prefixes.put(-1, "tiny");
        prefixes.put(1, "single_compressed");
        prefixes.put(2, "double_compressed");
        prefixes.put(3, "triple_compressed");
        prefixes.put(4, "quadruple_compressed");
        prefixes.put(5, "quintuple_compressed");
        prefixes.put(6, "sextuple_compressed");
        prefixes.put(7, "septuple_compressed");
        prefixes.put(8, "octuple_compressed");
    }
}

