/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.incorporeal.util;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplerRegistry<T>
implements Iterable<T> {
    public final Map<T, ResourceLocation> thingsToIds = new IdentityHashMap<T, ResourceLocation>();
    public final Map<ResourceLocation, T> idsToThings = new LinkedHashMap<ResourceLocation, T>();

    public synchronized T register(T thing, ResourceLocation id) {
        this.thingsToIds.put(thing, id);
        this.idsToThings.put(id, thing);
        return thing;
    }

    public ResourceLocation getKey(T thing) {
        return this.thingsToIds.get(thing);
    }

    public T get(@Nullable ResourceLocation id) {
        return this.idsToThings.get(id);
    }

    public Optional<T> optionalGet(@Nullable ResourceLocation id) {
        return Optional.ofNullable(this.get(id));
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.idsToThings.values().iterator();
    }
}

