/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.api;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

public class MixinHelper {
    public static boolean isLithiumLoaded(Class<?> clz) {
        return MixinHelper.contains(MixinHelper.isClassPatched(clz.getCanonicalName()), "lithium");
    }

    public static Set<String> isClassPatched(String className) {
        LinkedHashMap<String, Set<String>> map = new LinkedHashMap<String, Set<String>>();
        try {
            Field field = ClassInfo.class.getDeclaredField("cache");
            field.setAccessible(true);
            Map info = (Map)field.get(null);
            for (Map.Entry entry : info.entrySet()) {
                MixinHelper.load((String)entry.getKey(), ((ClassInfo)entry.getValue()).getAppliedMixins().stream().flatMap(T -> T.getTargetClasses().stream()).iterator(), map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map.getOrDefault(className.replace(".", "/"), new LinkedHashSet());
    }

    public static boolean contains(Set<String> set, String searchString) {
        for (String s : set) {
            if (!s.toLowerCase().contains(searchString)) continue;
            return true;
        }
        return false;
    }

    private static void load(String source, Iterator<String> keys, Map<String, Set<String>> map) {
        Iterable iter = () -> keys;
        for (String s : iter) {
            map.computeIfAbsent(s, T -> new LinkedHashSet()).add(source);
        }
    }
}

