/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSink;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import pregenerator.base.impl.PregenCheckBox;
import pregenerator.base.impl.PregenSlider;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;

public abstract class BasePregenScreen
extends Screen {
    protected int centerX;
    protected int centerY;
    protected int tick;

    protected BasePregenScreen(Component titleIn) {
        super(titleIn);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.m_169413_();
    }

    public void m_96624_() {
        super.m_96624_();
        ++this.tick;
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partial) {
        super.m_6305_(matrix, mouseX, mouseY, partial);
    }

    public boolean m_7043_() {
        return false;
    }

    public Button registerButton(int x, int y, int width, int height, String name, Button.OnPress pressable) {
        ExtendedButton button = new ExtendedButton(x + this.centerX, y + this.centerY, width, height, (Component)new TextComponent(name), pressable);
        this.m_142416_((GuiEventListener)button);
        return button;
    }

    public Button registerSimpleButton(int x, int y, int width, int height, String name, Button.OnPress pressable) {
        ExtendedButton button = new ExtendedButton(x, y, width, height, (Component)new TextComponent(name), pressable);
        this.m_142416_((GuiEventListener)button);
        return button;
    }

    public PregenCheckBox registerCheckbox(int x, int y, int width, int height, String text, boolean checked) {
        PregenCheckBox check = new PregenCheckBox(x + this.centerX, y + this.centerY, width, height, text, checked, T -> {});
        this.m_142416_((GuiEventListener)check);
        return check;
    }

    public PregenCheckBox registerCheckbox(int x, int y, int width, int height, String text, boolean checked, Button.OnPress handler) {
        PregenCheckBox check = new PregenCheckBox(x + this.centerX, y + this.centerY, width, height, text, checked, handler);
        this.m_142416_((GuiEventListener)check);
        return check;
    }

    public EditBox registerText(int x, int y, int width, int height, String original) {
        EditBox widget = new EditBox(this.f_96547_, x + this.centerX, y + this.centerY, width, height, (Component)new TextComponent(""));
        widget.m_94144_(original);
        this.m_142416_((GuiEventListener)widget);
        return widget;
    }

    public EditBox registerSimpleText(int x, int y, int width, int height, String original) {
        EditBox widget = new EditBox(this.f_96547_, x, y, width, height, (Component)new TextComponent(""));
        widget.m_94144_(original);
        this.m_142416_((GuiEventListener)widget);
        return widget;
    }

    public PregenSlider registerSlider(int x, int y, int width, int height, String prefix, String postfix, double minVal, double maxVal, double currentVal, Consumer<PregenSlider> listener) {
        PregenSlider slider = new PregenSlider(x + this.centerX, y + this.centerY, width, height, prefix, postfix, minVal, maxVal, currentVal, listener);
        this.m_142416_((GuiEventListener)slider);
        return slider;
    }

    public PregenSlider registerSimpleSlider(int x, int y, int width, int height, String prefix, String postfix, double minVal, double maxVal, double currentVal, Consumer<PregenSlider> listener) {
        PregenSlider slider = new PregenSlider(x, y, width, height, prefix, postfix, minVal, maxVal, currentVal, listener);
        this.m_142416_((GuiEventListener)slider);
        return slider;
    }

    public void drawText(PoseStack matrix, String s, int x, int y, int color) {
        this.f_96547_.m_92877_(matrix, new TextComponent(s).m_7532_(), (float)(this.centerX + x), (float)(this.centerY + y), color);
    }

    public void drawText(PoseStack matrix, FormattedText s, int x, int y, int color) {
        this.f_96547_.m_92877_(matrix, Language.m_128107_().m_5536_(s), (float)(this.centerX + x), (float)(this.centerY + y), color);
    }

    public void drawSimpleText(PoseStack matrix, String s, int x, int y, int color) {
        this.f_96547_.m_92877_(matrix, new TextComponent(s).m_7532_(), (float)x, (float)y, color);
    }

    public void drawCenterText(PoseStack matrix, String s, int x, int y, int color) {
        this.f_96547_.m_92877_(matrix, new TextComponent(s).m_7532_(), (float)(this.centerX + x - this.f_96547_.m_92895_(s) / 2), (float)(this.centerY + y), color);
    }

    public void drawLeftText(PoseStack matrix, String s, int x, int y, int color) {
        this.f_96547_.m_92877_(matrix, new TextComponent(s).m_7532_(), (float)(this.centerX + x - this.f_96547_.m_92895_(s)), (float)(this.centerY + y), color);
    }

    public void renderTextureWithOffset(PoseStack stack, float x, float y, float width, float height) {
        this.renderTexture(stack, x + (float)this.centerX, y + (float)this.centerY, width, height);
    }

    public void renderTexture(PoseStack stack, float x, float y, float width, float height, TextureAtlasSprite texture, BufferBuilder builder) {
        if (texture == null) {
            return;
        }
        Matrix4f matrix = stack.m_85850_().m_85861_();
        builder.m_85982_(matrix, x, y + height, (float)this.m_93252_()).m_7421_(texture.m_118409_(), texture.m_118412_()).m_5752_();
        builder.m_85982_(matrix, x + width, y + height, (float)this.m_93252_()).m_7421_(texture.m_118410_(), texture.m_118412_()).m_5752_();
        builder.m_85982_(matrix, x + width, y, (float)this.m_93252_()).m_7421_(texture.m_118410_(), texture.m_118411_()).m_5752_();
        builder.m_85982_(matrix, x, y, (float)this.m_93252_()).m_7421_(texture.m_118409_(), texture.m_118411_()).m_5752_();
    }

    public void renderTexture(PoseStack stack, float x, float y, float width, float height) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Matrix4f matrix = stack.m_85850_().m_85861_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, x, y + height, (float)this.m_93252_()).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrix, x + width, y + height, (float)this.m_93252_()).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrix, x + width, y, (float)this.m_93252_()).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(matrix, x, y, (float)this.m_93252_()).m_7421_(0.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
    }

    public void drawSimpleRect(PoseStack stack, int minX, int minY, int maxX, int maxY, int color, boolean drop) {
        if (drop) {
            BasePregenScreen.m_93172_((PoseStack)stack, (int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-13158601);
            BasePregenScreen.m_93172_((PoseStack)stack, (int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-1);
        } else {
            BasePregenScreen.m_93172_((PoseStack)stack, (int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-13158601);
            BasePregenScreen.m_93172_((PoseStack)stack, (int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-1);
        }
        BasePregenScreen.m_93172_((PoseStack)stack, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)color);
    }

    public void drawRectangle(PoseStack stack, int xSize, int ySize, int xOffset, int yOffset, int color, boolean drop) {
        int minX = this.centerX - xSize + xOffset;
        int minY = this.centerY - ySize + yOffset;
        int maxX = this.centerX + xSize + xOffset;
        int maxY = this.centerY + ySize + yOffset;
        if (drop) {
            BasePregenScreen.m_93172_((PoseStack)stack, (int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-13158601);
            BasePregenScreen.m_93172_((PoseStack)stack, (int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-1);
        } else {
            BasePregenScreen.m_93172_((PoseStack)stack, (int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-13158601);
            BasePregenScreen.m_93172_((PoseStack)stack, (int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-1);
        }
        BasePregenScreen.m_93172_((PoseStack)stack, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)color);
    }

    public boolean isInsideBox(int mouseX, int mouseY, int minX, int minY, int maxX, int maxY) {
        return mouseX >= this.centerX + minX && mouseX < this.centerX + maxX && mouseY >= this.centerY + minY && mouseY <= this.centerY + maxY;
    }

    public void fill(PoseStack stack, float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        GlStateManager.m_84525_();
        GlStateManager.m_84110_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = stack.m_85850_().m_85861_();
        bufferbuilder.m_85982_(matrix, minX, maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrix, maxX, maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrix, maxX, minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrix, minX, minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        tessellator.m_85914_();
        GlStateManager.m_84109_();
        GlStateManager.m_84519_();
    }

    public void drawQuadArea(PoseStack matrix, float left, float top, float right, float bottom, BufferBuilder builder, int color) {
        if (left < right) {
            float i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            float j = top;
            top = bottom;
            bottom = j;
        }
        Matrix4f stack = matrix.m_85850_().m_85861_();
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        builder.m_85982_(stack, left, bottom, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        builder.m_85982_(stack, right, bottom, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        builder.m_85982_(stack, right, top, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        builder.m_85982_(stack, left, top, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
    }

    public void sendToServer(IPregenPacket packet) {
        NetworkManager.INSTANCE.sendToServer(packet);
    }

    public static String convertText(Component component) {
        StringConsumer consumer = new StringConsumer();
        component.m_7532_().m_13731_((FormattedCharSink)consumer);
        return consumer.getBuilder().toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class StringConsumer
    implements FormattedCharSink {
        StringBuilder builder = new StringBuilder();
        ChatFormatting formatting = ChatFormatting.RESET;

        public boolean m_6411_(int index, Style style, int character) {
            ChatFormatting format = this.getFormat(style);
            if (format != this.formatting) {
                this.formatting = format;
                this.builder.append(format.toString());
            }
            this.builder.append((char)character);
            return true;
        }

        protected ChatFormatting getFormat(Style style) {
            ChatFormatting format = style.m_131135_() == null ? null : ChatFormatting.m_126657_((String)style.m_131135_().m_131274_());
            return format == null ? ChatFormatting.RESET : format;
        }

        public StringBuilder getBuilder() {
            return this.builder;
        }
    }
}

