/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.info;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.base.api.Align;
import pregenerator.base.api.IRenderHelper;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.ChunkLogger;

public class DeletionProcessorInfo
implements IProcessorInfo {
    boolean running;
    boolean prepairing;
    long duration;
    long totalChunks;
    long chunksDone;
    long chunksFailed;
    IDeletionTask task;
    String taskName;
    long prepaireValue;
    long prepaireMax;
    long totalMemory;
    long maxMemory;
    long freeMemory;

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.prepairing = buffer.readBoolean();
        this.taskName = buffer.m_130277_();
        this.totalMemory = buffer.readLong();
        this.maxMemory = buffer.readLong();
        this.freeMemory = buffer.readLong();
        if (this.prepairing) {
            this.prepaireValue = buffer.readLong();
            this.prepaireMax = buffer.readLong();
            return;
        }
        this.running = buffer.readBoolean();
        this.duration = buffer.readLong();
        this.totalChunks = buffer.readLong();
        this.chunksDone = buffer.readLong();
        this.chunksFailed = buffer.readLong();
        this.task = IDeletionTask.loadTask(buffer.m_130260_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(IRenderHelper helper, int x, int y) {
        ResourceKey<Level> type = this.task == null ? Level.f_46428_ : this.task.getDimension();
        helper.drawArea(x, y, 100, this.prepairing || !this.running ? 27 : 40);
        helper.drawText(x + 54, y + 3, Align.CENTER, "Deletion Task");
        helper.drawText(x + 4, y + 8, Align.START, "Task Name: " + this.taskName);
        helper.drawText(x + 4, y + 13, Align.START, "Dimension: " + ChunkLogger.toPascalCase(type.m_135782_().m_135815_()));
        if (this.prepairing) {
            helper.drawText(x + 4, y + 18, Align.START, "Prepairing Task");
            helper.drawProgressBar(x + 4, y + 23, 100, 5, this.maxMemory <= 0L ? 0.0f : (float)(this.totalMemory - this.freeMemory) / (float)this.maxMemory, "Ram: (" + FORMAT.format(IProcessorInfo.toMB(this.totalMemory - this.freeMemory)) + " MB / " + FORMAT.format(IProcessorInfo.toMB(this.maxMemory)) + " MB)");
            helper.drawProgressBar(x + 4, y + 28, 100, 5, this.prepaireMax <= 0L ? 0.0f : (float)this.prepaireValue / (float)this.prepaireMax, "Progress: " + FORMAT.format(this.prepaireValue) + " / " + FORMAT.format(this.prepaireMax));
            return;
        }
        if (!this.running) {
            helper.drawText(x + 4, y + 18, Align.START, "Task Paused");
            helper.drawProgressBar(x + 4, y + 23, 100, 5, this.maxMemory <= 0L ? 0.0f : (float)(this.totalMemory - this.freeMemory) / (float)this.maxMemory, "Ram: (" + FORMAT.format(IProcessorInfo.toMB(this.totalMemory - this.freeMemory)) + " MB / " + FORMAT.format(IProcessorInfo.toMB(this.maxMemory)) + " MB)");
            return;
        }
        helper.drawText(x + 4, y + 18, Align.START, "Running Time: " + DurationFormatUtils.formatDuration((long)this.duration, (String)"HH:mm:ss"));
        helper.drawProgressBar(x + 4, y + 23, 100, 5, this.maxMemory <= 0L ? 0.0f : (float)(this.totalMemory - this.freeMemory) / (float)this.maxMemory, "Ram: (" + FORMAT.format(IProcessorInfo.toMB(this.totalMemory - this.freeMemory)) + " MB / " + FORMAT.format(IProcessorInfo.toMB(this.maxMemory)) + " MB)");
        helper.drawText(x + 4, y + 30, Align.START, "Deletion Progress:");
        helper.drawProgressBar(x + 4, y + 35, 100, 5, (float)this.chunksDone / (float)this.totalChunks, FORMAT.format(this.chunksDone) + " / " + FORMAT.format(this.totalChunks));
        helper.drawText(x + 4, y + 41, Align.START, "Failed Chunks: " + this.chunksFailed);
    }

    @Override
    public int getID() {
        return 2;
    }

    @Override
    public int getWidth() {
        return 109;
    }

    @Override
    public int getHeight() {
        return this.prepairing || !this.running ? 34 : 47;
    }
}

