/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;

public class InfoCommand {
    public static CommandBuilder createInfoCommand() {
        CommandBuilder builder = new CommandBuilder("info");
        builder.addLiteral("listen", (Command<CommandSourceStack>)((Command)InfoCommand::listen)).popTop();
        builder.addLiteral("unlisten", (Command<CommandSourceStack>)((Command)InfoCommand::unlisten)).popTop();
        builder.addLiteral("autolisten", (Command<CommandSourceStack>)((Command)InfoCommand::autoListenState)).addLiteral("enable", (Command<CommandSourceStack>)((Command)InfoCommand::enableAuto)).pop();
        builder.addLiteral("disable", (Command<CommandSourceStack>)((Command)InfoCommand::disableAuto)).pop();
        builder.addLiteral("reset", (Command<CommandSourceStack>)((Command)InfoCommand::resetAuto)).popTop();
        return builder;
    }

    static UUID getSender(CommandContext<CommandSourceStack> source) {
        Entity entity = ((CommandSourceStack)source.getSource()).m_81373_();
        return entity instanceof Player ? entity.m_142081_() : null;
    }

    public static int listen(CommandContext<CommandSourceStack> source) {
        ServerManager.INSTANCE.addListener(InfoCommand.getSender(source));
        return 0;
    }

    public static int unlisten(CommandContext<CommandSourceStack> source) {
        ServerManager.INSTANCE.removeListener(InfoCommand.getSender(source));
        return 0;
    }

    public static int enableAuto(CommandContext<CommandSourceStack> source) {
        if (TaskStorage.getListeners().add(InfoCommand.getSender(source), true)) {
            ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent(((CommandSourceStack)source.getSource()).m_81368_() + " started Listening to Tasks"), true);
        } else {
            ((CommandSourceStack)source.getSource()).m_81352_((Component)new TextComponent(((CommandSourceStack)source.getSource()).m_81368_() + " already Listening to Tasks"));
        }
        return 0;
    }

    public static int disableAuto(CommandContext<CommandSourceStack> source) {
        if (TaskStorage.getListeners().add(InfoCommand.getSender(source), false)) {
            ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent(((CommandSourceStack)source.getSource()).m_81368_() + " started Ignoring Tasks"), true);
        } else {
            ((CommandSourceStack)source.getSource()).m_81352_((Component)new TextComponent(((CommandSourceStack)source.getSource()).m_81368_() + " already Ignoring Tasks"));
        }
        return 0;
    }

    public static int resetAuto(CommandContext<CommandSourceStack> source) {
        TaskStorage.getListeners().remove(InfoCommand.getSender(source));
        ((CommandSourceStack)source.getSource()).m_81352_((Component)new TextComponent(((CommandSourceStack)source.getSource()).m_81368_() + " Reseted Task Listening"));
        return 0;
    }

    public static int autoListenState(CommandContext<CommandSourceStack> source) {
        switch (TaskStorage.getListeners().getState(InfoCommand.getSender(source))) {
            case 0: {
                ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent(((CommandSourceStack)source.getSource()).m_81368_() + " is not Listening to Tasks"), true);
                break;
            }
            case 1: {
                ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent(((CommandSourceStack)source.getSource()).m_81368_() + " is Ignoring Tasks"), true);
                break;
            }
            case 2: {
                ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent(((CommandSourceStack)source.getSource()).m_81368_() + " is Listening to Tasks"), true);
            }
        }
        return 0;
    }
}

