/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import pregenerator.common.base.GenTaskStorage;
import pregenerator.common.base.SimpleTaskStorage;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.commands.BenchmarkCommand;
import pregenerator.common.commands.DeletionCommand;
import pregenerator.common.commands.GenCommand;
import pregenerator.common.commands.InfoCommand;
import pregenerator.common.commands.RetrogenCommand;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.DimensionManager;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;

public class PregenCommand {
    public static PregenCommand INSTANCE = new PregenCommand();

    public static void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher, boolean advArgs) {
        CommandBuilder source = new CommandBuilder(LiteralArgumentBuilder.literal((String)"pregen").requires(T -> T.m_6761_(3)));
        CommandBuilder builder = new CommandBuilder("start");
        builder.merge(GenCommand.INSTANCE.createGenStart(advArgs)).popTop();
        builder.merge(DeletionCommand.createDeletionCommand(advArgs)).popTop();
        builder.merge(BenchmarkCommand.createBenchmark(advArgs)).popTop();
        source.merge(builder).popTop();
        source.merge(RetrogenCommand.createRetogenCommand()).popTop();
        source.merge(InfoCommand.createInfoCommand()).popTop();
        PregenCommand.createControlTasks(source).popTop();
        source.merge(INSTANCE.createSimpleTasks(new CommandBuilder("utils"))).popTop();
        dispatcher.getRoot().addChild(source.build());
    }

    static CommandBuilder createControlTasks(CommandBuilder source) {
        source.addLiteral("taskList").addLiteral("gen", (Command<CommandSourceStack>)((Command)PregenCommand::listGenTasks)).pop();
        source.addLiteral("deletion", (Command<CommandSourceStack>)((Command)PregenCommand::listDeletionTasks)).popTop();
        Command cmd = T -> ServerManager.INSTANCE.pauseTask(new CommandWrapper((CommandContext<CommandSourceStack>)T).getOrDefault("Task Name", String.class, null), V -> ((CommandSourceStack)T.getSource()).m_81354_(V, false));
        source.addLiteral("pause", (Command<CommandSourceStack>)cmd).addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word(), (Command<CommandSourceStack>)cmd).popTop();
        cmd = T -> ServerManager.INSTANCE.resumeTask(new CommandWrapper((CommandContext<CommandSourceStack>)T).getOrDefault("Task Name", String.class, null), V -> ((CommandSourceStack)T.getSource()).m_81354_(V, false));
        source.addLiteral("resume", (Command<CommandSourceStack>)cmd).addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word(), (Command<CommandSourceStack>)cmd).popTop();
        source.addLiteral("continue", (Command<CommandSourceStack>)((Command)PregenCommand::continueAny));
        source.addArgument((ArgumentBuilder<CommandSourceStack, ?>)((RequiredArgumentBuilder)Commands.m_82129_((String)"Task Name", (ArgumentType)StringArgumentType.word()).executes(PregenCommand::continueTask)).suggests((T, V) -> SharedSuggestionProvider.m_82970_(TaskStorage.getTasks(), (SuggestionsBuilder)V))).popTop();
        source.addLiteral("stop", (Command<CommandSourceStack>)((Command)PregenCommand::stopAll));
        source.addArgument((ArgumentBuilder<CommandSourceStack, ?>)((RequiredArgumentBuilder)Commands.m_82129_((String)"Task Name", (ArgumentType)StringArgumentType.word()).executes(PregenCommand::stopTask)).suggests((T, V) -> SharedSuggestionProvider.m_82970_(TaskStorage.getActiveTasks(), (SuggestionsBuilder)V)));
        source.addArgument("Delete Task", (ArgumentType<?>)BoolArgumentType.bool(), (Command<CommandSourceStack>)((Command)PregenCommand::stopTask)).popTop();
        source.addLiteral("clear", (Command<CommandSourceStack>)((Command)PregenCommand::clearTask));
        source.addArgument((ArgumentBuilder<CommandSourceStack, ?>)((RequiredArgumentBuilder)Commands.m_82129_((String)"Task Name", (ArgumentType)StringArgumentType.word()).executes(PregenCommand::clearTask)).suggests((T, V) -> SharedSuggestionProvider.m_82970_(TaskStorage.getTasks(), (SuggestionsBuilder)V))).popTop();
        source.addLiteral("processors", (Command<CommandSourceStack>)((Command)PregenCommand::processorCount)).popTop();
        return source;
    }

    protected CommandBuilder createSimpleTasks(CommandBuilder source) {
        source.addLiteral("dimensions").addLiteral("info", (Command<CommandSourceStack>)((Command)PregenCommand::infoDimensions)).pop();
        source.addLiteral("disable").addArgument("dim", (ArgumentType<?>)DimensionArgument.m_88805_(), (Command<CommandSourceStack>)((Command)PregenCommand::disableDimension)).pop(2);
        source.addLiteral("enable").addArgument("dim", (ArgumentType<?>)DimensionArgument.m_88805_(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(K, V) -> SharedSuggestionProvider.m_82926_(DimensionManager.DimensionRegistry.getRegistry().getDims(), (SuggestionsBuilder)V)), (Command<CommandSourceStack>)((Command)PregenCommand::enableDimension)).popTop();
        return source;
    }

    private static int disableDimension(CommandContext<CommandSourceStack> source) {
        DimensionManager.INSTANCE.disableDimension((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)((ResourceLocation)source.getArgument("dim", ResourceLocation.class))), T -> ((CommandSourceStack)source.getSource()).m_81354_(T, true));
        return 0;
    }

    private static int enableDimension(CommandContext<CommandSourceStack> source) {
        DimensionManager.INSTANCE.enableDimension((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)((ResourceLocation)source.getArgument("dim", ResourceLocation.class))), T -> ((CommandSourceStack)source.getSource()).m_81354_(T, true));
        return 0;
    }

    private static int infoDimensions(CommandContext<CommandSourceStack> source) {
        ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent("The Dimension Command allows you to \"Disable\" Dimensions."), true);
        ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent("Disabling a Dimension will make it inaccessible for the game and it will be treated like as if the Dimension never existed in the first place"), true);
        ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent("On top of that Disabled Dimensions will load on Startup and will be automatically shutdown. This will increase restart time for a tiny bit."), true);
        ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent("Once ChunkPregen is deinstalled all Dimensions will load like normal but the \"Disabling Information\" is stored in the world itself so removing/adding the mod will not change anything"), true);
        return 0;
    }

    private static int processorCount(CommandContext<CommandSourceStack> source) {
        ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent("This Command checks how many CPU cores the JVM can actually see. This allows you to see if the docker Configuration is done properly"), true);
        ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent("CPU Count: " + Runtime.getRuntime().availableProcessors() + ", ProcessorCount: " + ServerManager.INSTANCE.getProcessors()), true);
        return 0;
    }

    private static int continueTask(CommandContext<CommandSourceStack> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        return ServerManager.INSTANCE.continueTask(wrapper.getOrDefault("Task Name", String.class, null), wrapper.getSenderId(), wrapper);
    }

    private static int continueAny(CommandContext<CommandSourceStack> source) {
        ServerManager.INSTANCE.continueTask(T -> ((CommandSourceStack)source.getSource()).m_81354_(T, true));
        return 0;
    }

    private static int clearTask(CommandContext<CommandSourceStack> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        return ServerManager.INSTANCE.removeTask(wrapper.getOrDefault("Task Name", String.class, null), wrapper);
    }

    private static int stopTask(CommandContext<CommandSourceStack> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        if (wrapper.getOrDefault("Delete Task", Boolean.class, false).booleanValue()) {
            return ServerManager.INSTANCE.removeTask(wrapper.get("Task Name", String.class), wrapper);
        }
        return ServerManager.INSTANCE.stopTask(wrapper.get("Task Name", String.class), wrapper, false);
    }

    private static int stopAll(CommandContext<CommandSourceStack> source) {
        return ServerManager.INSTANCE.stopTask(null, T -> ((CommandSourceStack)source.getSource()).m_81354_(T, true), false);
    }

    private static int listGenTasks(CommandContext<CommandSourceStack> source) {
        GenTaskStorage storage = TaskStorage.getGenStorage();
        boolean empty = true;
        for (String s : storage.getTasks()) {
            empty = false;
            ITask task = (ITask)storage.getTask(s);
            MutableComponent desc = task.getTaskDescription();
            if (storage.isTaskActive(s)) {
                desc.m_130946_("[Active]");
            }
            ((CommandSourceStack)source.getSource()).m_81354_((Component)desc, false);
        }
        if (empty) {
            ((CommandSourceStack)source.getSource()).m_81352_((Component)new TextComponent("Task List Empty"));
        }
        return 0;
    }

    private static int listDeletionTasks(CommandContext<CommandSourceStack> source) {
        SimpleTaskStorage<IDeletionTask> storage = TaskStorage.getDeletionStorage();
        boolean empty = true;
        for (String s : storage.getTasks()) {
            empty = false;
            IDeletionTask task = storage.getTask(s);
            MutableComponent desc = task.getTaskDescription();
            if (storage.isTaskActive(s)) {
                desc.m_130946_("[Active]");
            }
            ((CommandSourceStack)source.getSource()).m_81354_((Component)desc, false);
        }
        if (empty) {
            ((CommandSourceStack)source.getSource()).m_81352_((Component)new TextComponent("Task List Empty"));
        }
        return 0;
    }
}

