/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public abstract class BaseDeletionTask
implements IDeletionTask {
    String name;
    ResourceKey<Level> type;

    public BaseDeletionTask(CompoundTag nbt) {
        this(nbt.m_128461_("name"), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dim"))));
    }

    public BaseDeletionTask(String name, ResourceKey<Level> type) {
        this.name = name;
        this.type = type;
    }

    public abstract void append(MutableComponent var1);

    public abstract ChunkDeleter createTask(ServerLevel var1, IProcess.PrepaireProgress var2);

    @Override
    public boolean isValid() {
        return this.type != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.type;
    }

    @Override
    public MutableComponent getTaskDescription() {
        TextComponent text = new TextComponent("[");
        ITask.convert("Name=" + this.getName() + ",", (MutableComponent)text, ChatFormatting.AQUA);
        ITask.convert("Dim=" + this.getDimension().getRegistryName().m_135815_() + ", ", (MutableComponent)text, ChatFormatting.GREEN);
        this.append((MutableComponent)text);
        return text.m_130946_("]");
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("name", this.name);
        nbt.m_128359_("dim", this.type.m_135782_().toString());
        return nbt;
    }

    @Override
    public CompletableFuture<ChunkDeleter> createTask(ServerLevel world, Executor exe, IProcess.PrepaireProgress progress) {
        return CompletableFuture.supplyAsync(() -> this.createTask(world, progress), exe);
    }

    protected Path getSaveFile() {
        return ServerLifecycleHooks.getCurrentServer().m_129843_(LevelResource.f_78182_).getParent();
    }

    protected boolean isRegionFile(Path path) {
        return path.getFileName().toString().endsWith(".mca");
    }

    protected List<Path> getRegionFiles() {
        try {
            return ObjectIterators.pour(Files.newDirectoryStream(DimensionType.m_196975_(this.getDimension(), (Path)this.getSaveFile()).resolve("region"), this::isRegionFile).iterator());
        }
        catch (IOException e) {
            return ObjectLists.emptyList();
        }
    }
}

